/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.swt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.interpolator.PropertyInterpolatorSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTPropertyInterpolators
implements PropertyInterpolatorSource {
    private Set<PropertyInterpolator> interpolators = new HashSet<PropertyInterpolator>();

    public SWTPropertyInterpolators() {
        this.interpolators.add(new ColorInterpolator());
        this.interpolators.add(new PointInterpolator());
        this.interpolators.add(new RectangleInterpolator());
    }

    @Override
    public Set<PropertyInterpolator> getPropertyInterpolators() {
        return Collections.unmodifiableSet(this.interpolators);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RectangleInterpolator
    implements PropertyInterpolator<Rectangle> {
        RectangleInterpolator() {
        }

        @Override
        public Rectangle interpolate(Rectangle from, Rectangle to, float timelinePosition) {
            int x = from.x + (int)(timelinePosition * (float)(to.x - from.x));
            int y = from.y + (int)(timelinePosition * (float)(to.y - from.y));
            int w = from.width + (int)(timelinePosition * (float)(to.width - from.width));
            int h = from.height + (int)(timelinePosition * (float)(to.height - from.height));
            return new Rectangle(x, y, w, h);
        }

        @Override
        public Class getBasePropertyClass() {
            return Rectangle.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PointInterpolator
    implements PropertyInterpolator<Point> {
        PointInterpolator() {
        }

        @Override
        public Point interpolate(Point from, Point to, float timelinePosition) {
            int x = from.x + (int)(timelinePosition * (float)(to.x - from.x));
            int y = from.y + (int)(timelinePosition * (float)(to.y - from.y));
            return new Point(x, y);
        }

        @Override
        public Class getBasePropertyClass() {
            return Point.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColorInterpolator
    implements PropertyInterpolator<Color> {
        ColorInterpolator() {
        }

        @Override
        public Class getBasePropertyClass() {
            return Color.class;
        }

        @Override
        public Color interpolate(Color from, Color to, float timelinePosition) {
            return this.getInterpolatedColor(from, to, 1.0f - timelinePosition);
        }

        RGB getInterpolatedRGB(Color color1, Color color2, float color1Likeness) {
            if ((double)color1Likeness < 0.0 || (double)color1Likeness > 1.0) {
                throw new IllegalArgumentException("Color likeness should be in 0.0-1.0 range [is " + color1Likeness + "]");
            }
            int lr = color1.getRed();
            int lg = color1.getGreen();
            int lb = color1.getBlue();
            int dr = color2.getRed();
            int dg = color2.getGreen();
            int db = color2.getBlue();
            int r = lr == dr ? lr : (int)Math.round((double)(color1Likeness * (float)lr) + (1.0 - (double)color1Likeness) * (double)dr);
            int g = lg == dg ? lg : (int)Math.round((double)(color1Likeness * (float)lg) + (1.0 - (double)color1Likeness) * (double)dg);
            int b = lb == db ? lb : (int)Math.round((double)(color1Likeness * (float)lb) + (1.0 - (double)color1Likeness) * (double)db);
            return new RGB(r, g, b);
        }

        Color getInterpolatedColor(Color color1, Color color2, float color1Likeness) {
            if (color1.equals((Object)color2)) {
                return color1;
            }
            if ((double)color1Likeness == 1.0) {
                return color1;
            }
            if ((double)color1Likeness == 0.0) {
                return color2;
            }
            return new Color((Device)Display.getDefault(), this.getInterpolatedRGB(color1, color2, color1Likeness));
        }
    }
}

