/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.AbstractAsyncWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncSAMFileWriter
extends AbstractAsyncWriter<SAMRecord>
implements SAMFileWriter {
    private final SAMFileWriter underlyingWriter;

    public AsyncSAMFileWriter(SAMFileWriter out) {
        this(out, 2000);
    }

    public AsyncSAMFileWriter(SAMFileWriter out, int queueSize) {
        super(queueSize);
        this.underlyingWriter = out;
    }

    @Override
    protected void synchronouslyWrite(SAMRecord item) {
        this.underlyingWriter.addAlignment(item);
    }

    @Override
    protected void synchronouslyClose() {
        this.underlyingWriter.close();
    }

    @Override
    protected final String getThreadNamePrefix() {
        return "SAMFileWriterThread-";
    }

    @Override
    public void addAlignment(SAMRecord alignment) {
        this.write(alignment);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.underlyingWriter.getFileHeader();
    }
}

