/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.surface;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.surface.ColorModelSet;
import net.ericaro.surfaceplotter.surface.Projector;
import net.ericaro.surfaceplotter.surface.SurfaceColor;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceVertex;

public abstract class AbstractSurfaceModel
implements SurfaceModel {
    private static final int INIT_CALC_DIV = 20;
    private static final int INIT_DISP_DIV = 20;
    protected boolean autoScaleZ = true;
    protected boolean boxed;
    protected int calcDivisions = 20;
    protected ColorModelSet colorModel;
    protected int contourLines;
    protected boolean dataAvailable;
    protected int dispDivisions = 20;
    protected boolean displayGrids;
    protected boolean displayXY;
    protected boolean displayZ;
    protected boolean expectDelay = false;
    protected boolean hasFunction1 = true;
    protected boolean hasFunction2 = true;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean mesh;
    protected SurfaceModel.PlotColor plotColor;
    protected boolean plotFunction1 = this.hasFunction1;
    protected boolean plotFunction2 = this.hasFunction2;
    protected SurfaceModel.PlotType plotType = SurfaceModel.PlotType.SURFACE;
    private Projector projector;
    protected PropertyChangeSupport property = new SwingPropertyChangeSupport(this);
    protected boolean scaleBox;
    protected float xMax = 1.0f;
    protected float xMin;
    protected float yMax = 1.0f;
    protected float yMin;
    protected float z1Max;
    protected float z1Min;
    protected float z2Max;
    protected float z2Min;
    protected float zMax;
    protected float zMin;

    public static synchronized double ceil(double d, int digits) {
        if (d == 0.0) {
            return d;
        }
        long og = (long)Math.ceil(Math.log(Math.abs(d)) / Math.log(10.0));
        double factor = Math.pow(10.0, (long)digits - og);
        double res = Math.ceil(d * factor) / factor;
        return res;
    }

    public static synchronized double floor(double d, int digits) {
        if (d == 0.0) {
            return d;
        }
        long og = (long)Math.ceil(Math.log(Math.abs(d)) / Math.log(10.0));
        double factor = Math.pow(10.0, (long)digits - og);
        double res = Math.floor(d * factor) / factor;
        return res;
    }

    public AbstractSurfaceModel() {
        this.setColorModel(new ColorModelSet());
        this.setCalcDivisions(50);
        this.setDispDivisions(50);
        this.setContourLines(10);
        this.setXMin(-3.0f);
        this.setXMax(3.0f);
        this.setYMin(-3.0f);
        this.setYMax(3.0f);
        this.setBoxed(false);
        this.setDisplayXY(false);
        this.setExpectDelay(false);
        this.setAutoScaleZ(true);
        this.setDisplayZ(false);
        this.setMesh(true);
        this.setPlotType(SurfaceModel.PlotType.SURFACE);
        this.setFirstFunctionOnly(true);
        this.setPlotColor(SurfaceModel.PlotColor.SPECTRUM);
    }

    public void addChangeListener(ChangeListener ol) {
        this.listenerList.add(ChangeListener.class, ol);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.property.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.property.addPropertyChangeListener(propertyName, listener);
    }

    public void autoScale() {
        if (!this.autoScaleZ) {
            return;
        }
        if (this.plotFunction1 && this.plotFunction2) {
            this.setZMin(Math.min(this.z1Min, this.z2Min));
            this.setZMax(Math.max(this.z1Max, this.z2Max));
        } else {
            if (this.plotFunction1) {
                this.setZMin(this.z1Min);
                this.setZMax(this.z1Max);
            }
            if (this.plotFunction2) {
                this.setZMin(this.z2Min);
                this.setZMax(this.z2Max);
            }
        }
    }

    public void exportCSV(File file) throws IOException {
        float yx;
        float xx;
        float yi;
        float xi;
        SurfaceVertex[][] surfaceVertex = this.getSurfaceVertex();
        if (file == null) {
            return;
        }
        FileWriter w = new FileWriter(file);
        try {
            xi = this.getXMin();
            yi = this.getYMin();
            xx = this.getXMax();
            yx = this.getYMax();
            if (xi >= xx || yi >= yx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.setMessage("Error in ranges");
            return;
        }
        this.calcDivisions = this.getCalcDivisions();
        float stepx = (xx - xi) / (float)this.calcDivisions;
        float stepy = (yx - yi) / (float)this.calcDivisions;
        if (surfaceVertex == null) {
            return;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        float x = xi;
        float y = yi;
        w.write("X\\Y->Z;");
        while (j <= this.calcDivisions) {
            w.write(Float.toString(y));
            if (j != this.calcDivisions) {
                w.write(59);
            }
            ++j;
            y += stepy;
            ++k;
        }
        w.write("\n");
        i = 0;
        j = 0;
        k = 0;
        x = xi;
        y = yi;
        while (i <= this.calcDivisions) {
            w.write(Float.toString(x));
            w.write(59);
            while (j <= this.calcDivisions) {
                w.write(Float.toString(surfaceVertex[0][k].z));
                if (j != this.calcDivisions) {
                    w.write(59);
                }
                ++j;
                y += stepy;
                ++k;
            }
            w.write(10);
            j = 0;
            y = yi;
            ++i;
            x += stepx;
        }
        w.flush();
        w.close();
    }

    private void fireAllFunction(boolean oldHas1, boolean oldHas2) {
        this.property.firePropertyChange("firstFunctionOnly", !oldHas2 && oldHas1, !this.plotFunction2 && this.plotFunction1);
        this.property.firePropertyChange("secondFunctionOnly", !oldHas1 && oldHas2, !this.plotFunction1 && this.plotFunction2);
        this.property.firePropertyChange("bothFunction", oldHas1 && oldHas2, this.plotFunction1 && this.plotFunction2);
        this.autoScale();
    }

    private void fireAllMode(SurfaceModel.PlotColor oldValue, SurfaceModel.PlotColor newValue) {
        for (SurfaceModel.PlotColor c : SurfaceModel.PlotColor.values()) {
            this.property.firePropertyChange(c.getPropertyName(), oldValue == c, newValue == c);
        }
    }

    private void fireAllType(SurfaceModel.PlotType oldValue, SurfaceModel.PlotType newValue) {
        for (SurfaceModel.PlotType c : SurfaceModel.PlotType.values()) {
            this.property.firePropertyChange(c.getPropertyName(), oldValue == c, newValue == c);
        }
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    public int getCalcDivisions() {
        return this.calcDivisions;
    }

    public SurfaceColor getColorModel() {
        return this.colorModel;
    }

    public int getContourLines() {
        return this.contourLines;
    }

    public int getDispDivisions() {
        if (this.dispDivisions > this.calcDivisions) {
            this.dispDivisions = this.calcDivisions;
        }
        while (this.calcDivisions % this.dispDivisions != 0) {
            ++this.dispDivisions;
        }
        return this.dispDivisions;
    }

    public SurfaceModel.PlotColor getPlotColor() {
        return this.plotColor;
    }

    public SurfaceModel.PlotType getPlotType() {
        return this.plotType;
    }

    public Projector getProjector() {
        if (this.projector == null) {
            this.projector = new Projector();
            this.projector.setDistance(70.0f);
            this.projector.set2DScaling(15.0f);
            this.projector.setRotationAngle(125.0f);
            this.projector.setElevationAngle(10.0f);
        }
        return this.projector;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.property == null) {
            this.property = new SwingPropertyChangeSupport(this);
        }
        return this.property;
    }

    public float getXMax() {
        return this.xMax;
    }

    public float getXMin() {
        return this.xMin;
    }

    public float getYMax() {
        return this.yMax;
    }

    public float getYMin() {
        return this.yMin;
    }

    public float getZMax() {
        return this.zMax;
    }

    public float getZMin() {
        return this.zMin;
    }

    public boolean isAutoScaleZ() {
        return this.autoScaleZ;
    }

    public boolean isBothFunction() {
        return this.plotFunction1 && this.plotFunction2;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public boolean isContourType() {
        return this.plotType == SurfaceModel.PlotType.CONTOUR;
    }

    public boolean isDataAvailable() {
        return this.dataAvailable;
    }

    public boolean isDensityType() {
        return this.plotType == SurfaceModel.PlotType.DENSITY;
    }

    public boolean isDisplayGrids() {
        return this.displayGrids;
    }

    public boolean isDisplayXY() {
        return this.displayXY;
    }

    public boolean isDisplayZ() {
        return this.displayZ;
    }

    public boolean isDualShadeMode() {
        return this.plotColor == SurfaceModel.PlotColor.DUALSHADE;
    }

    public boolean isExpectDelay() {
        return this.expectDelay;
    }

    public boolean isFirstFunctionOnly() {
        return this.plotFunction1 && !this.plotFunction2;
    }

    public boolean isFogMode() {
        return this.plotColor == SurfaceModel.PlotColor.FOG;
    }

    public boolean isGrayScaleMode() {
        return this.plotColor == SurfaceModel.PlotColor.GRAYSCALE;
    }

    public boolean isHiddenMode() {
        return this.plotColor == SurfaceModel.PlotColor.OPAQUE;
    }

    public boolean isMesh() {
        return this.mesh;
    }

    public boolean isPlotFunction1() {
        return this.plotFunction1;
    }

    public boolean isPlotFunction2() {
        return this.plotFunction2;
    }

    public boolean isScaleBox() {
        return this.scaleBox;
    }

    public boolean isSecondFunctionOnly() {
        return !this.plotFunction1 && this.plotFunction2;
    }

    public boolean isSpectrumMode() {
        return this.plotColor == SurfaceModel.PlotColor.SPECTRUM;
    }

    public boolean isSurfaceType() {
        return this.plotType == SurfaceModel.PlotType.SURFACE;
    }

    public boolean isWireframeType() {
        return this.plotType == SurfaceModel.PlotType.WIREFRAME;
    }

    public void removeChangeListener(ChangeListener ol) {
        this.listenerList.remove(ChangeListener.class, ol);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.property.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.property.removePropertyChangeListener(propertyName, listener);
    }

    public void rotationStops() {
    }

    public void setAutoScaleZ(boolean autoScaleZ) {
        this.autoScaleZ = autoScaleZ;
        this.getPropertyChangeSupport().firePropertyChange("this.autoScaleZ", this.autoScaleZ, this.autoScaleZ);
        this.autoScale();
    }

    public void setBothFunction(boolean val) {
        this.setPlotFunction12(val, val);
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
        this.getPropertyChangeSupport().firePropertyChange("boxed", this.boxed, this.boxed);
    }

    protected void setColorModel(ColorModelSet colorModel) {
        this.colorModel = colorModel;
        this.getPropertyChangeSupport().firePropertyChange("colorModel", this.colorModel, this.colorModel);
        if (colorModel != null) {
            colorModel.setPlotColor(this.plotColor);
            colorModel.setPlotType(this.plotType);
        }
    }

    public void setContourLines(int contourLines) {
        this.contourLines = contourLines;
        this.getPropertyChangeSupport().firePropertyChange("contourLines", this.contourLines, this.contourLines);
    }

    public void setContourType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.CONTOUR : SurfaceModel.PlotType.SURFACE);
    }

    public void setDataAvailable(boolean dataAvailable) {
        this.dataAvailable = dataAvailable;
        this.getPropertyChangeSupport().firePropertyChange("dataAvailable", this.dataAvailable, this.dataAvailable);
    }

    public void setDensityType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.DENSITY : SurfaceModel.PlotType.SURFACE);
    }

    public void setDispDivisions(int dispDivisions) {
        this.dispDivisions = dispDivisions;
        this.getPropertyChangeSupport().firePropertyChange("dispDivisions", this.dispDivisions, this.dispDivisions);
    }

    public void setDualShadeMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.DUALSHADE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public void setFirstFunctionOnly(boolean val) {
        this.setPlotFunction12(val, !val);
    }

    public void setFogMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.FOG : SurfaceModel.PlotColor.SPECTRUM);
    }

    public void setGrayScaleMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.GRAYSCALE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public void setHiddenMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.OPAQUE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public abstract void setMapper(Mapper var1);

    public void setMessage(String text) {
    }

    public void setPlotFunction1(boolean plotFunction1) {
        this.setPlotFunction12(plotFunction1, this.plotFunction2);
    }

    public void setPlotColor(SurfaceModel.PlotColor plotColor) {
        SurfaceModel.PlotColor old = this.plotColor;
        this.plotColor = plotColor;
        this.getPropertyChangeSupport().firePropertyChange("plotColor", (Object)this.plotColor, (Object)this.plotColor);
        this.fireAllMode(old, this.plotColor);
        if (this.colorModel != null) {
            this.colorModel.setPlotColor(plotColor);
        }
    }

    public void setPlotFunction12(boolean p1, boolean p2) {
        boolean o1 = this.plotFunction1;
        boolean o2 = this.plotFunction2;
        this.plotFunction1 = this.hasFunction1 && p1;
        this.property.firePropertyChange("plotFunction1", o1, p1);
        this.plotFunction2 = this.hasFunction2 && p2;
        this.property.firePropertyChange("plotFunction1", o2, p2);
        this.fireAllFunction(o1, o2);
    }

    public void setPlotFunction2(boolean v) {
        this.setPlotFunction12(this.plotFunction1, this.plotFunction2);
    }

    public void setPlotType(SurfaceModel.PlotType plotType) {
        SurfaceModel.PlotType o = this.plotType;
        this.plotType = plotType;
        if (this.colorModel != null) {
            this.colorModel.setPlotType(plotType);
        }
        this.property.firePropertyChange("plotType", (Object)o, (Object)this.plotType);
        this.fireAllType(o, this.plotType);
    }

    public void setSecondFunctionOnly(boolean val) {
        this.setPlotFunction12(!val, val);
    }

    public void setSpectrumMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.SPECTRUM : SurfaceModel.PlotColor.GRAYSCALE);
    }

    public void setSurfaceType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.SURFACE : SurfaceModel.PlotType.WIREFRAME);
    }

    public void setWireframeType(boolean val) {
        if (val) {
            this.setPlotType(SurfaceModel.PlotType.WIREFRAME);
        } else {
            this.setPlotType(SurfaceModel.PlotType.SURFACE);
        }
    }

    public void setXMax(float xMax) {
        this.xMax = xMax;
        this.getPropertyChangeSupport().firePropertyChange("xMax", Float.valueOf(this.xMax), Float.valueOf(this.xMax));
    }

    public void setXMin(float xMin) {
        this.xMin = xMin;
        this.getPropertyChangeSupport().firePropertyChange("xMin", Float.valueOf(this.xMin), Float.valueOf(this.xMin));
    }

    public void setYMax(float yMax) {
        this.yMax = yMax;
        this.getPropertyChangeSupport().firePropertyChange("yMax", Float.valueOf(this.yMax), Float.valueOf(this.yMax));
    }

    public void setYMin(float yMin) {
        this.yMin = yMin;
        this.getPropertyChangeSupport().firePropertyChange("yMin", Float.valueOf(this.yMin), Float.valueOf(this.yMin));
    }

    public void setZMax(float zMax) {
        if (zMax <= this.zMin) {
            return;
        }
        this.zMax = zMax;
        this.getPropertyChangeSupport().firePropertyChange("zMax", Float.valueOf(this.zMax), Float.valueOf(this.zMax));
    }

    public void setZMin(float zMin) {
        if (zMin >= this.zMax) {
            return;
        }
        this.zMin = zMin;
        this.getPropertyChangeSupport().firePropertyChange("zMin", Float.valueOf(this.zMin), Float.valueOf(this.zMin));
    }

    public void setDisplayGrids(boolean displayGrids) {
        this.displayGrids = displayGrids;
        this.getPropertyChangeSupport().firePropertyChange("displayGrids", this.displayGrids, this.displayGrids);
    }

    public void setDisplayXY(boolean displayXY) {
        this.displayXY = displayXY;
        this.getPropertyChangeSupport().firePropertyChange("displayXY", this.displayXY, this.displayXY);
    }

    public void setDisplayZ(boolean displayZ) {
        this.displayZ = displayZ;
        this.getPropertyChangeSupport().firePropertyChange("displayZ", this.displayZ, this.displayZ);
    }

    public void setExpectDelay(boolean expectDelay) {
        this.expectDelay = expectDelay;
        this.getPropertyChangeSupport().firePropertyChange("expectDelay", this.expectDelay, this.expectDelay);
    }

    public void setMesh(boolean mesh) {
        this.mesh = mesh;
        this.getPropertyChangeSupport().firePropertyChange("mesh", this.mesh, this.mesh);
    }

    public void setScaleBox(boolean scaleBox) {
        this.scaleBox = scaleBox;
        this.getPropertyChangeSupport().firePropertyChange("scaleBox", this.scaleBox, this.scaleBox);
    }

    public void toggleAutoScaleZ() {
        this.setAutoScaleZ(!this.isAutoScaleZ());
    }

    public void toggleBoxed() {
        this.setBoxed(!this.isBoxed());
    }

    public void setCalcDivisions(int calcDivisions) {
        this.calcDivisions = calcDivisions;
        this.getPropertyChangeSupport().firePropertyChange("calcDivisions", this.calcDivisions, this.calcDivisions);
    }

    public void toggleDisplayGrids() {
        this.setDisplayGrids(!this.isDisplayGrids());
    }

    public void toggleDisplayXY() {
        this.setDisplayXY(!this.isDisplayXY());
    }

    public void toggleDisplayZ() {
        this.setDisplayZ(!this.isDisplayZ());
    }

    public void toggleExpectDelay() {
        this.setExpectDelay(!this.isExpectDelay());
    }

    public void toggleMesh() {
        this.setMesh(!this.isMesh());
    }

    public void togglePlotFunction1() {
        this.setPlotFunction1(!this.isPlotFunction1());
    }

    public void togglePlotFunction2() {
        this.setPlotFunction2(!this.isPlotFunction2());
    }

    public void toggleScaleBox() {
        this.setScaleBox(!this.isScaleBox());
    }

    public static interface Plotter {
        public int getHeight();

        public int getWidth();

        public float getX(int var1);

        public float getY(int var1);

        public void setValue(int var1, int var2, float var3, float var4);
    }
}

