/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.beans;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanProperty<BEAN, PROP> {
    BEAN bean;
    String propertyName;
    PropertyChangeListener propertyObserver = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (BeanProperty.this.propertyName != null && BeanProperty.this.propertyName.equals(evt.getPropertyName())) {
                BeanProperty.this.onPropertyChanged(evt);
            }
        }
    };
    transient BeanInfo beaninfo;
    transient EventSetDescriptor eventSetDescriptor;
    transient PropertyDescriptor propertyDescriptor;

    public void setBean(BEAN model) {
        BEAN old = this.bean;
        this.bean = model;
        this.bind(old);
    }

    protected abstract void onPropertyChanged(PropertyChangeEvent var1);

    public PROP getProperty() {
        if (this.propertyDescriptor == null || this.bean == null) {
            return null;
        }
        try {
            return (PROP)this.propertyDescriptor.getReadMethod().invoke(this.bean, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setProperty(PROP value) {
        if (this.propertyDescriptor == null) {
            return;
        }
        try {
            this.propertyDescriptor.getWriteMethod().invoke(this.bean, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.bind(this.bean);
    }

    public BEAN getBean() {
        return this.bean;
    }

    private Object unregister(Object bean) {
        if (bean != null && this.propertyObserver != null) {
            try {
                this.eventSetDescriptor.getRemoveListenerMethod().invoke(bean, this.propertyObserver);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getProperty();
    }

    private Object register() {
        this.beaninfo = null;
        this.eventSetDescriptor = null;
        this.propertyDescriptor = null;
        if (this.bean != null) {
            try {
                this.beaninfo = Introspector.getBeanInfo(this.bean.getClass());
                for (PropertyDescriptor propertyDescriptor : this.beaninfo.getPropertyDescriptors()) {
                    if (!propertyDescriptor.getName().equals(this.propertyName)) continue;
                    this.propertyDescriptor = propertyDescriptor;
                    break;
                }
                for (FeatureDescriptor featureDescriptor : this.beaninfo.getEventSetDescriptors()) {
                    if (((EventSetDescriptor)featureDescriptor).getListenerType() != PropertyChangeListener.class) continue;
                    this.eventSetDescriptor = featureDescriptor;
                    break;
                }
                if (this.propertyObserver != null) {
                    this.eventSetDescriptor.getAddListenerMethod().invoke(this.bean, this.propertyObserver);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getProperty();
    }

    private void bind(Object oldBean) {
        Object oldValue = this.unregister(oldBean);
        Object newValue = this.register();
        if (this.bean != null && this.propertyName != null) {
            this.onPropertyChanged(new PropertyChangeEvent(this.bean, this.propertyName, oldValue, newValue));
        }
    }
}

