/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Chartable3D;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;

public abstract class AbstractBarRenderer
extends AbstractRenderer
implements BarRenderer {
    private boolean e = false;
    private boolean f = false;
    private LabelStyle g = new LabelStyle();
    private PointLabeler h = null;

    public boolean isLabelsVisible() {
        return this.f;
    }

    public void setLabelsVisible(boolean bl) {
        this.f = bl;
    }

    public LabelStyle getLabelStyle() {
        return this.g;
    }

    public void setLabelStyle(LabelStyle labelStyle) {
        this.g = labelStyle;
    }

    public PointLabeler getPointLabeler() {
        return this.h;
    }

    public void setPointLabeler(PointLabeler pointLabeler) {
        this.h = pointLabeler;
    }

    public boolean isZeroHeightBarsVisible() {
        return this.e;
    }

    public void setZeroHeightBarsVisible(boolean bl) {
        this.e = bl;
    }

    protected void renderBarLabel(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5) {
        block9: {
            double d6;
            int n;
            FontMetrics fontMetrics;
            String string;
            block8: {
                LabelStyle labelStyle;
                ChartStyle chartStyle;
                boolean bl4 = AbstractRenderer.d;
                string = this.computeLabel(chartable);
                if (string == null) {
                    return;
                }
                ChartStyle chartStyle2 = chartStyle = chart.getStyle(chartModel);
                if (!bl4) {
                    if (chartStyle2 == null) {
                        chartStyle = new ChartStyle();
                    }
                    chartStyle2 = chartStyle;
                }
                Orientation orientation = chartStyle2.getBarOrientation();
                LabelStyle labelStyle2 = labelStyle = this.getLabelStyle();
                if (!bl4) {
                    if (labelStyle2 == null) {
                        labelStyle = new LabelStyle();
                    }
                    labelStyle2 = labelStyle;
                }
                Color color = labelStyle2.getColor();
                graphics2D.setColor(color);
                Font font = labelStyle.getFont();
                fontMetrics = graphics2D.getFontMetrics(font);
                if (orientation != Orientation.vertical) break block8;
                n = fontMetrics.stringWidth(string);
                d6 = d2 + d4 / 2.0;
                int n2 = fontMetrics.getDescent();
                graphics2D.drawString(string, (float)(d6 - (double)n / 2.0), (float)(d3 - (double)n2));
                if (!bl4) break block9;
            }
            n = fontMetrics.charWidth('o');
            d6 = d3 + d5 / 2.0 + (double)fontMetrics.getAscent() / 2.0 - (double)fontMetrics.getDescent();
            graphics2D.drawString(string, (float)(d2 + d4 + (double)n / 2.0), (float)d6);
        }
    }

    protected String computeLabel(Chartable chartable) {
        Positionable positionable;
        boolean bl;
        block7: {
            PointLabeler pointLabeler;
            block6: {
                PointLabeler pointLabeler2;
                bl = AbstractRenderer.d;
                if (chartable == null) {
                    return "";
                }
                pointLabeler = pointLabeler2 = this.getPointLabeler();
                if (bl) break block6;
                if (pointLabeler == null) break block7;
                pointLabeler = this.h;
            }
            return pointLabeler.getDisplayText(chartable);
        }
        Chartable chartable2 = chartable;
        if (!bl) {
            if (chartable2 instanceof Chartable3D) {
                Positionable positionable2 = ((Chartable3D)chartable).getZ();
                return positionable2 == null ? "" : "" + positionable2.position();
            }
            chartable2 = chartable;
        }
        return (positionable = chartable2.getY()) == null ? "" : "" + positionable.position();
    }

    protected Paint createBarPaint(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
        return null;
    }

    protected Paint getBarColor(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, boolean bl3) {
        Color color;
        block15: {
            Paint paint;
            block12: {
                boolean bl4;
                block13: {
                    boolean bl5;
                    block14: {
                        block11: {
                            block9: {
                                block8: {
                                    ChartStyle chartStyle2;
                                    block10: {
                                        ChartStyle chartStyle3;
                                        Highlightable highlightable;
                                        Highlight highlight;
                                        ChartStyle chartStyle4;
                                        block7: {
                                            bl5 = AbstractRenderer.d;
                                            paint = Color.lightGray;
                                            chartStyle4 = chartStyle;
                                            if (bl5) break block7;
                                            if (chartStyle4 == null) break block8;
                                            chartStyle4 = chartStyle;
                                        }
                                        bl4 = chartStyle4.isBarsVisible();
                                        if (bl5) break block9;
                                        if (!bl4) break block8;
                                        paint = chartStyle.getBarPaint();
                                        bl4 = chartable instanceof Highlightable;
                                        if (bl5) break block9;
                                        if (!bl4 || (highlight = (highlightable = (Highlightable)((Object)chartable)).getHighlight()) == null) break block8;
                                        chartStyle2 = chartStyle3 = chart.getHighlightStyle(highlight);
                                        if (bl5) break block10;
                                        if (chartStyle2 == null) break block8;
                                        chartStyle2 = chartStyle3;
                                    }
                                    paint = chartStyle2.getBarPaint();
                                }
                                bl4 = bl2;
                            }
                            if (bl5) break block11;
                            if (!bl4) break block12;
                            bl4 = paint instanceof Color;
                        }
                        if (bl5) break block13;
                        if (!bl4) break block14;
                        paint = ColorFactory.intensify2(paint, 50);
                        if (!bl5) break block12;
                    }
                    color = paint;
                    if (bl5) break block15;
                    bl4 = color instanceof TexturePaint;
                }
                if (bl4) {
                    paint = this.a((TexturePaint)paint);
                }
            }
            color = paint;
        }
        return color;
    }

    private TexturePaint a(TexturePaint texturePaint) {
        BufferedImage bufferedImage = texturePaint.getImage();
        a_ a_2 = new a_();
        BufferedImage bufferedImage2 = a_2.filter(bufferedImage, null);
        return new TexturePaint(bufferedImage2, new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    class a_
    implements BufferedImageOp {
        a_() {
        }

        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            block3: {
                ColorModel colorModel2;
                block2: {
                    colorModel2 = colorModel;
                    if (AbstractRenderer.d) break block2;
                    if (colorModel2 != null) break block3;
                    colorModel2 = bufferedImage.getColorModel();
                }
                colorModel = colorModel2;
            }
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        }

        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            block4: {
                boolean bl = AbstractRenderer.d;
                BufferedImage bufferedImage3 = bufferedImage2;
                if (!bl) {
                    if (bufferedImage3 == null) {
                        bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
                    }
                    bufferedImage3 = bufferedImage;
                }
                int n = bufferedImage3.getWidth();
                int n2 = bufferedImage.getHeight();
                int[] nArray = new int[n * n2];
                ChartUtils.getPixels(bufferedImage, 0, 0, n, n2, nArray);
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    Color color = new Color(nArray[i2], true);
                    nArray[i2] = color.brighter().getRGB();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block4;
                }
                ChartUtils.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
            }
            return bufferedImage2;
        }

        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

