/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.axis.DefaultTimeTickCalculator;
import com.jidesoft.chart.axis.TimeTickCalculator;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeAxis
extends Axis {
    private TimeTickCalculator C = new DefaultTimeTickCalculator();

    public TimeAxis() {
        this.setRange((Range<?>)this.createDefaultRange());
        this.init();
    }

    public TimeAxis(String string) {
        super(string);
        this.setRange((Range<?>)this.createDefaultRange());
        this.init();
    }

    public TimeAxis(AutoPositionedLabel autoPositionedLabel) {
        super(autoPositionedLabel);
        this.setRange((Range<?>)this.createDefaultRange());
        this.init();
    }

    public TimeAxis(long l2, long l3) {
        super((Range<?>)new TimeRange(l2, l3));
        this.init();
    }

    public TimeAxis(TimeRange timeRange) {
        super((Range<?>)timeRange);
        this.init();
    }

    public TimeAxis(TimeRange timeRange, String string) {
        super((Range<?>)timeRange, string);
        this.init();
    }

    protected TimeRange createDefaultRange() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        calendar.add(5, 1);
        long l3 = calendar.getTimeInMillis();
        return new TimeRange(l2, l3);
    }

    protected void init() {
        this.setTickCalculator(this.C);
    }

    public void setDateFormat(DateFormat dateFormat) {
        TimeTickCalculator timeTickCalculator = (TimeTickCalculator)this.getTickCalculator();
        timeTickCalculator.setDateFormat(dateFormat);
    }

    public DateFormat getDateFormat() {
        TimeTickCalculator timeTickCalculator = (TimeTickCalculator)this.getTickCalculator();
        return timeTickCalculator.getDateFormat();
    }

    public TimeAxis withDateFormat(DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public TimeZone getTimeZone() {
        TimeTickCalculator timeTickCalculator = (TimeTickCalculator)this.getTickCalculator();
        return timeTickCalculator.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeTickCalculator timeTickCalculator = (TimeTickCalculator)this.getTickCalculator();
        timeTickCalculator.setTimeZone(timeZone);
    }

    public AxisQuantity getQuantity() {
        return AxisQuantity.TIME;
    }
}

