/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.savant.analytics.savantanalytics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class AnalyticsAgent {
    static boolean sessionActive = false;
    private static String sessionID;
    private static String softwareName;
    private static String softwareVersion;
    private static Locale locale;
    private static Properties p;
    private static NameValuePair[] standardKeyValues;
    private static final String UNDEFINED_VERSION = "";

    public static void onStartSession(String softwareName, String softwareVersion) {
        System.out.println("Starting session");
        locale = Locale.getDefault();
        AnalyticsAgent.softwareName = softwareName;
        AnalyticsAgent.softwareVersion = softwareVersion;
        AnalyticsAgent.beginSession();
        AnalyticsAgent.log("SessionStart", false);
    }

    public static void onEndSession(boolean synchronous) {
        System.out.println("Ending session");
        AnalyticsAgent.endSession(synchronous);
    }

    public static void log(String message, boolean async) {
        AnalyticsAgent.log(AnalyticsAgent.nvp("msg", message), async);
    }

    public static void log(String message) {
        AnalyticsAgent.log(message, true);
    }

    public static void log(NameValuePair kvp, boolean async) {
        AnalyticsAgent.log(new NameValuePair[]{kvp}, async);
    }

    public static void log(NameValuePair kvp) {
        AnalyticsAgent.log(kvp, true);
    }

    public static void log(final NameValuePair[] kvps, boolean async) {
        if (sessionActive) {
            if (async) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AnalyticsAgent.doLog(kvps);
                    }
                }).start();
            } else {
                AnalyticsAgent.doLog(kvps);
            }
        }
    }

    private static void doLog(NameValuePair[] kvps) {
        try {
            HttpClient httpClient = new HttpClient();
            PostMethod post = new PostMethod("http://genomesavant.com/u/labs/usage/usage.php");
            Object[] data = (NameValuePair[])ArrayUtils.addAll((Object[])kvps, (Object[])standardKeyValues);
            data = (NameValuePair[])ArrayUtils.addAll((Object[])data, (Object[])AnalyticsAgent.dynamicKeyValues());
            post.setRequestBody((NameValuePair[])data);
            httpClient.executeMethod((HttpMethod)post);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(NameValuePair[] kvps) {
        AnalyticsAgent.log(kvps, true);
    }

    private static void endSession(boolean synchronous) {
        AnalyticsAgent.log("SessionEnd", !synchronous);
        sessionID = null;
        sessionActive = false;
    }

    private static void beginSession() {
        sessionID = RandomStringUtils.random((int)20, (String)"0123456789abcdefghijklmnopqrstuvwxyz");
        sessionActive = true;
        standardKeyValues = new NameValuePair[]{AnalyticsAgent.nvp("software-name", softwareName), AnalyticsAgent.nvp("session-id", sessionID), AnalyticsAgent.nvp("agent-version", AnalyticsAgent.getAnalyticsAgentVersion())};
        String address = "unknown";
        try {
            address = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        AnalyticsAgent.log(new NameValuePair[]{AnalyticsAgent.nvp("system-java-version", System.getProperty("java.version")), AnalyticsAgent.nvp("system-java-vendor", System.getProperty("java.vendor")), AnalyticsAgent.nvp("system-os-arch", System.getProperty("os.arch")), AnalyticsAgent.nvp("system-os-name", System.getProperty("os.name")), AnalyticsAgent.nvp("system-os-version", System.getProperty("os.version")), AnalyticsAgent.nvp("client-ip", address), AnalyticsAgent.nvp("msg", "NewSession")});
    }

    private static NameValuePair nvp(String name, String value) {
        return new NameValuePair(name, value);
    }

    private static NameValuePair[] dynamicKeyValues() {
        return new NameValuePair[]{AnalyticsAgent.nvp("client-time", new Date().toGMTString())};
    }

    private static String getAnalyticsAgentVersion() {
        String version = UNDEFINED_VERSION;
        Package aPackage = AnalyticsAgent.class.getPackage();
        if (aPackage != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = UNDEFINED_VERSION;
        }
        return version;
    }

    static {
        p = new Properties(System.getProperties());
    }
}

