/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils.zip;

import ch.enterag.utils.zip.EntryInputStream;
import ch.enterag.utils.zip.FileEntry;
import ch.enterag.utils.zip.Zip64File;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class BugsZip64File {
    private static final int iBUFFER_SIZE = 8192;

    private int extractEntry(Zip64File zf, FileEntry fe, String sTempFolder) {
        int iReturn = -1;
        String sFileEntry = fe.getName();
        if (fe.isDirectory()) {
            File fileEntry = new File(String.valueOf(sTempFolder) + "/" + sFileEntry);
            if (!fileEntry.exists()) {
                fileEntry.mkdirs();
            }
            iReturn = 0;
        } else {
            File fileEntry;
            String sPath = "";
            String sFile = sFileEntry;
            int iPath = sFileEntry.lastIndexOf(47);
            if (iPath >= 0) {
                sPath = sFileEntry.substring(0, iPath + 1);
                sFile = sFileEntry.substring(iPath + 1);
            }
            if (!(fileEntry = new File(String.valueOf(sTempFolder) + "/" + sPath)).exists()) {
                fileEntry.mkdirs();
            }
            try {
                fileEntry = new File(String.valueOf(fileEntry.getAbsolutePath()) + "/" + sFile);
                FileOutputStream fos = new FileOutputStream(fileEntry);
                EntryInputStream eis = zf.openEntryInputStream(sFileEntry);
                byte[] buffer = new byte[8192];
                int iRead = eis.read(buffer, 0, 8192);
                while (iRead != -1) {
                    fos.write(buffer, 0, iRead);
                    iRead = eis.read(buffer, 0, 8192);
                }
                eis.close();
                fos.close();
                iReturn = 0;
            }
            catch (IOException ie) {
                System.out.println(String.valueOf(ie.getClass().getName()) + ": " + ie.getMessage() + " (File: " + fileEntry.getAbsolutePath() + ")");
            }
        }
        return iReturn;
    }

    private int readEmptyFolders(String sFilename, String sTempFolder) {
        int iReturn = 0;
        try {
            Zip64File zf = new Zip64File(sFilename, true);
            int iEntries = zf.getFileEntries();
            System.out.println("ZIP file has " + String.valueOf(iEntries) + " entries.");
            List listEntry = zf.getListFileEntries();
            Iterator iterEntry = listEntry.iterator();
            while (iReturn == 0 && iterEntry.hasNext()) {
                FileEntry fe = (FileEntry)iterEntry.next();
                System.out.println("  " + fe.getName());
                iReturn = this.extractEntry(zf, fe, sTempFolder);
            }
            zf.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File " + sFilename + " not found!");
        }
        catch (IOException ie) {
            System.out.println(String.valueOf(ie.getClass().getName()) + ": " + ie.getMessage() + " (File: " + sFilename + ")");
        }
        return iReturn;
    }

    public static void main(String[] args) {
        BugsZip64File bzf = new BugsZip64File();
        File fileEmptyFolders = new File("data/EmptyFolders.zip");
        if (fileEmptyFolders.exists()) {
            String sTempFolder = "C:\\Temp";
            System.exit(bzf.readEmptyFolders(fileEmptyFolders.getAbsolutePath(), sTempFolder));
        } else {
            System.err.println("File " + fileEmptyFolders.getAbsolutePath() + " does not exist!");
            System.exit(-1);
        }
    }
}

