/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils;

import ch.enterag.utils.BU;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SU {
    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isNotWhite(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String replace(String s, String sFind, String sReplace) {
        StringBuffer sb = new StringBuffer();
        if (SU.isNotEmpty(s)) {
            int iStart = 0;
            int iMatch = s.indexOf(sFind, iStart);
            while (iMatch >= 0) {
                sb.append(s.substring(iStart, iMatch));
                sb.append(sReplace);
                iStart = iMatch + sFind.length();
                iMatch = s.indexOf(sFind, iStart);
            }
            sb.append(s.substring(iStart, s.length()));
        }
        return sb.toString();
    }

    public static String repeat(int iRepetitions, char c) {
        StringBuffer sb = new StringBuffer(iRepetitions);
        int i = 0;
        while (i < iRepetitions) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String repeat(int iRepetitions, String s) {
        StringBuffer sb = new StringBuffer(iRepetitions);
        int i = 0;
        while (i < iRepetitions) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static int getBreakPoint(String s, int iStart, int iEnd) {
        int iBreak;
        if (iEnd > s.length()) {
            iEnd = s.length();
        }
        if ((iBreak = s.indexOf(10, iStart) + 1) <= iStart || iBreak > iEnd) {
            iBreak = iEnd;
            if (iEnd < s.length() && s.charAt(iEnd) != ' ') {
                int i = iEnd - 1;
                while (iBreak == iEnd && i > iStart) {
                    char c = s.charAt(i + 1);
                    if (c == ' ' || c == '-' || c == '\n' || c == '\r' || c == '\t') {
                        iBreak = i + 1;
                    }
                    --i;
                }
            }
        }
        return iBreak;
    }

    private static byte[] putEncodedCharArray(char[] ac, int iOffset, int iLength, String sEncoding) {
        byte[] buf = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(iLength);
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, sEncoding);
            int i = iOffset;
            while (i < iOffset + iLength) {
                osw.write(ac[i]);
                ++i;
            }
            osw.close();
            buf = baos.toByteArray();
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println(String.valueOf(uee.getClass().getName()) + ":" + uee.getMessage());
        }
        catch (IOException ie) {
            System.out.println(String.valueOf(ie.getClass().getName()) + ":" + ie.getMessage());
        }
        return buf;
    }

    public static byte[] putUtf8CharArray(char[] ac, int iOffset, int iLength) {
        return SU.putEncodedCharArray(ac, iOffset, iLength, "UTF8");
    }

    private static byte[] putEncodedString(String s, String sEncoding) {
        byte[] buf = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length());
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, sEncoding);
            osw.write(s);
            osw.close();
            buf = baos.toByteArray();
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println(String.valueOf(uee.getClass().getName()) + ":" + uee.getMessage());
        }
        catch (IOException ie) {
            System.out.println(String.valueOf(ie.getClass().getName()) + ":" + ie.getMessage());
        }
        return buf;
    }

    public static byte[] putUtf8String(String s) {
        return SU.putEncodedString(s, "UTF8");
    }

    public static byte[] putCp437String(String s) {
        return SU.putEncodedString(s, "Cp437");
    }

    private static String getEncodedString(byte[] buf, String sEncoding) {
        StringBuffer sb = new StringBuffer();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)bais, sEncoding);
            int i = isr.read();
            while (i != -1) {
                sb.append((char)i);
                i = isr.read();
            }
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println(String.valueOf(uee.getClass().getName()) + ":" + uee.getMessage());
        }
        catch (IOException ie) {
            System.out.println(String.valueOf(ie.getClass().getName()) + ":" + ie.getMessage());
        }
        return sb.toString();
    }

    public static String getUtf8String(byte[] buf) {
        return SU.getEncodedString(buf, "UTF8");
    }

    public static String getCp437String(byte[] buf) {
        return SU.getEncodedString(buf, "Cp437");
    }

    public static String toCsv(String sText) {
        sText = SU.replace(sText, "\\", "\\\\");
        sText = SU.replace(sText, "\n", "\\n");
        sText = SU.replace(sText, "\r", "\\r");
        sText = SU.replace(sText, "\t", "\\t");
        int i = 0;
        while (i < 32) {
            char c = (char)i;
            String s = String.valueOf(c);
            String sEntity = "\\x" + BU.toHex((byte)i);
            sText = SU.replace(sText, s, sEntity);
            ++i;
        }
        return sText;
    }

    public static String toXml(String sText, boolean bDom) {
        if (SU.isNotWhite(sText)) {
            String s;
            char c;
            if (!bDom) {
                sText = SU.replace(sText, "&", "&amp;");
                sText = SU.replace(sText, "<", "&lt;");
                sText = SU.replace(sText, "\"", "&quot;");
            }
            sText = SU.replace(sText, "\\", "\\u005C");
            int i = 0;
            while (i < 32) {
                c = (char)i;
                s = String.valueOf(c);
                String sEntity = "\\u00" + BU.toHex((byte)i);
                sText = SU.replace(sText, s, sEntity);
                ++i;
            }
            i = 127;
            while (i < 160) {
                c = (char)i;
                s = String.valueOf(c);
                byte b = (byte)(0xFFFFFF00 | i);
                if (i < 128) {
                    b = (byte)i;
                }
                String sEntity = "\\u00" + BU.toHex(b);
                sText = SU.replace(sText, s, sEntity);
                ++i;
            }
            String sText1 = SU.replace(sText, "  ", " \\u0020");
            while (!sText.equals(sText1)) {
                sText = sText1;
                sText1 = SU.replace(sText, "  ", " \\u0020");
            }
        }
        return sText;
    }

    public static String fromXml(String sText, boolean bDom) {
        if (SU.isNotWhite(sText)) {
            String s;
            char c;
            sText = SU.replace(sText, "\n", " ");
            sText = SU.replace(sText, "\r", " ");
            sText = SU.replace(sText, "\t", " ");
            String sText1 = SU.replace(sText, "  ", " ");
            while (!sText.equals(sText1)) {
                sText = sText1;
                sText1 = SU.replace(sText, "  ", " ");
            }
            int i = 0;
            while (i <= 32) {
                c = (char)i;
                s = String.valueOf(c);
                String sEntity = "\\u00" + BU.toHex((byte)i);
                sText = SU.replace(sText, sEntity, s);
                ++i;
            }
            i = 127;
            while (i < 160) {
                c = (char)i;
                s = String.valueOf(c);
                byte b = (byte)(0xFFFFFF00 | i);
                if (i < 128) {
                    b = (byte)i;
                }
                String sEntity = "\\u00" + BU.toHex(b);
                sText = SU.replace(sText, s, sEntity);
                ++i;
            }
            sText = SU.replace(sText, "\\u005C", "\\");
            if (!bDom) {
                sText = SU.replace(sText, "&quot;", "\"");
                sText = SU.replace(sText, "&lt;", "<");
                sText = SU.replace(sText, "&amp;", "&");
            }
        }
        return sText;
    }
}

