/*
 * Decompiled with CFR 0.152.
 */
package ch.enterag.utils;

public class BU {
    private static final long lBYTE_MASK = 255L;
    private static final int iBYTE_MASK = 255;
    private static final int iNYBBLE_MASK = 15;
    private static String sHexDigits = "0123456789ABCDEF";

    private static byte lowByte(int i) {
        if ((i &= 0xFF) >= 128) {
            i -= 256;
        }
        return (byte)i;
    }

    public static short toShort(byte[] bufShort, int iPos) {
        short wShort = 0;
        int iByte = 0;
        if (bufShort.length < iPos + 2) {
            throw new IllegalArgumentException("byte buffer for short must have length >= 2!");
        }
        int i = iPos + 1;
        while (i >= iPos) {
            wShort = (short)(wShort << 8);
            iByte = bufShort[i];
            wShort = (short)(wShort | (iByte &= 0xFF));
            --i;
        }
        return wShort;
    }

    public static short toShort(byte[] bufShort) {
        return BU.toShort(bufShort, 0);
    }

    public static byte[] fromShort(short wShort) {
        byte[] bufShort = new byte[2];
        int i = 1;
        while (i >= 0) {
            bufShort[1 - i] = BU.lowByte(wShort);
            wShort = (short)(wShort >> 8);
            --i;
        }
        return bufShort;
    }

    public static int toInt(byte[] bufInt, int iPos) {
        int iInt = 0;
        int iByte = 0;
        if (bufInt.length < iPos + 4) {
            throw new IllegalArgumentException("byte buffer for int must have length >= 4!");
        }
        int i = iPos + 3;
        while (i >= iPos) {
            iInt <<= 8;
            iByte = bufInt[i];
            iInt |= (iByte &= 0xFF);
            --i;
        }
        return iInt;
    }

    public static int toInt(byte[] bufInt) {
        return BU.toInt(bufInt, 0);
    }

    public static byte[] fromInt(int iInt) {
        byte[] bufInt = new byte[4];
        int i = 3;
        while (i >= 0) {
            bufInt[3 - i] = BU.lowByte(iInt);
            iInt >>= 8;
            --i;
        }
        return bufInt;
    }

    public static long toLong(byte[] bufLong, int iPos) {
        long lLong = 0L;
        long lByte = 0L;
        if (bufLong.length < iPos + 8) {
            throw new IllegalArgumentException("byte buffer for long must have length >= 8!");
        }
        int i = iPos + 7;
        while (i >= iPos) {
            lLong <<= 8;
            lByte = bufLong[i];
            lLong |= (lByte &= 0xFFL);
            --i;
        }
        return lLong;
    }

    public static long toLong(byte[] bufLong) {
        return BU.toLong(bufLong, 0);
    }

    public static byte[] fromLong(long lLong) {
        byte[] bufLong = new byte[8];
        int i = 7;
        while (i >= 0) {
            bufLong[7 - i] = BU.lowByte((int)(lLong & 0xFFL));
            lLong >>= 8;
            --i;
        }
        return bufLong;
    }

    public static String toHex(byte b) {
        StringBuffer sbHex = new StringBuffer();
        int i = b & 0xFF;
        int iLow = i & 0xF;
        int iHigh = i >> 4;
        sbHex.append(sHexDigits.charAt(iHigh));
        sbHex.append(sHexDigits.charAt(iLow));
        return sbHex.toString();
    }

    public static String toHex(byte[] buffer, int iOffset, int iLength) {
        StringBuffer sbHex = new StringBuffer();
        int i = iOffset;
        while (i < iOffset + iLength) {
            sbHex.append(BU.toHex(buffer[i]));
            ++i;
        }
        return sbHex.toString();
    }

    public static String toHex(byte[] buffer) {
        return BU.toHex(buffer, 0, buffer.length);
    }

    public static byte fromHex(char cHigh, char cLow) {
        byte b = 0;
        int iHigh = sHexDigits.indexOf(cHigh);
        int iLow = sHexDigits.indexOf(cLow);
        if (iLow < 0 || iHigh < 0) {
            throw new IllegalArgumentException("Invalid hex data " + Character.toString(cHigh) + Character.toString(cLow) + "!");
        }
        int i = iHigh << 4;
        b = BU.lowByte(i += iLow);
        return b;
    }

    public static byte[] fromHex(String sHex) {
        if ((sHex.length() & 1) != 0) {
            throw new IllegalArgumentException("Hex string must have even number of hex digits!");
        }
        sHex = sHex.toUpperCase();
        byte[] buffer = new byte[sHex.length() / 2];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = BU.fromHex(sHex.charAt(2 * i), sHex.charAt(2 * i + 1));
            ++i;
        }
        return buffer;
    }
}

