/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.symbols;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pedviz.view.NodeView;
import pedviz.view.symbols.Symbol2D;

public class SymbolQualitativeTrait
extends Symbol2D {
    private Rectangle2D rectangle = new Rectangle2D.Double();
    Line2D.Float line = new Line2D.Float();
    private double min;
    private double max;
    private double mean;
    private double scope;
    private String userData;

    public SymbolQualitativeTrait(String userData, double min, double max, double mean, double scope) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.scope = scope;
        this.userData = userData;
    }

    public void drawSymbol(Graphics2D g, Point2D.Float position, float size, Color border, Color fill, NodeView nodeview) {
        if (nodeview.getNode().getUserData(this.userData) != null) {
            Double value = 0.0;
            value = nodeview.getNode().getUserData(this.userData) instanceof Double ? (Double)nodeview.getNode().getUserData(this.userData) : Double.valueOf(Double.parseDouble(nodeview.getNode().getUserData(this.userData).toString()));
            Shape oldclip = g.getClip();
            double scale = 4.0;
            float sizef = (float)((double)size * scale);
            Double diff = this.max - this.min;
            float posMean = (float)((this.mean - this.min) * (double)sizef / diff);
            float sizeScope = (float)(this.scope * (double)sizef / diff);
            float posValue = (float)((value - this.min) * (double)sizef / diff);
            float offsetY = sizef - posValue;
            float width = size / 3.0f;
            float left = (float)position.getX() + size / 2.0f;
            float offsetLine = 0.0f;
            if (offsetY < size / 2.0f) {
                offsetLine = offsetY - size / 2.0f;
                offsetY = size / 2.0f;
            }
            if (offsetY > sizef - size / 2.0f) {
                offsetLine = offsetY - (sizef - size / 2.0f);
                offsetY = sizef - size / 2.0f;
            }
            float topA = (float)position.getY() - offsetY;
            this.rectangle.setFrame(left, position.getY() - (double)(size / 2.0f), width, size);
            g.setClip(this.rectangle);
            GradientPaint gradient = new GradientPaint(left, topA, Color.red, left, topA + (sizef - posMean - sizeScope), Color.green);
            g.setPaint(gradient);
            this.rectangle.setFrame(left, topA, width, sizef - posMean - sizeScope);
            g.fill(this.rectangle);
            g.setColor(Color.green);
            this.rectangle.setFrame(left, topA + sizef - posMean - sizeScope, width, 2.0f * sizeScope);
            g.fill(this.rectangle);
            GradientPaint gradient2 = new GradientPaint(left, topA + sizef - posMean + sizeScope, Color.green, left, topA + sizef, Color.blue);
            g.setPaint(gradient2);
            this.rectangle.setFrame(left, topA + sizef - posMean + sizeScope / 2.0f, width, posMean - sizeScope);
            g.fill(this.rectangle);
            g.setClip(oldclip);
            g.setColor(Color.WHITE);
            this.line.setLine((double)left, position.getY() + (double)offsetLine, (double)(left + width), position.getY() + (double)offsetLine);
            g.draw(this.line);
            g.setColor(border);
            this.rectangle.setFrame(left, position.getY() - (double)(size / 2.0f), width, size);
            g.draw(this.rectangle);
        }
    }

    public int getPriority() {
        return 4;
    }
}

