/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.symbols;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import pedviz.graph.Node;
import pedviz.view.NodeView;
import pedviz.view.symbols.Symbol2D;

public class SymbolFamily
extends Symbol2D {
    private Ellipse2D ellipse = new Ellipse2D.Double();
    private Object male;
    private Object female;
    private double size = 0.6;
    int mode = 0;

    public SymbolFamily(int mode, Object male, Object female) {
        this.mode = mode;
        this.male = male;
        this.female = female;
    }

    public void drawSymbol(Graphics2D g, Point2D.Float position, float size, Color border, Color fill, NodeView nodeview) {
        if (this.mode > 0) {
            int cmale = 0;
            int cfemale = 0;
            for (Node child : nodeview.getNode().getNodes()) {
                cfemale += child.getUserData("SEX").equals(this.female) ? 1 : 0;
                cmale += child.getUserData("SEX").equals(this.male) ? 1 : 0;
            }
            Font oldfont = g.getFont();
            g.setColor(border);
            Font font = new Font("default", 0, (int)((double)size * this.size));
            g.setFont(font);
            if (nodeview.getNode().getNodeCount() > 0) {
                if (this.mode == 2) {
                    g.setColor(fill);
                    this.ellipse.setFrame(position.getX() - (double)size / 2.0 - 0.5, position.getY() - (double)size / 2.0 + 0.5, (double)size + 0.5, size - 1.0f);
                    g.fill(this.ellipse);
                    font = new Font("default", 0, (int)((double)size * this.size));
                    g.setFont(font);
                    float width = g.getFontMetrics().stringWidth("" + cfemale);
                    float height = g.getFontMetrics().getHeight();
                    g.setColor(Color.RED);
                    g.drawString("" + cfemale, position.x - width / 2.0f + size / 4.0f, position.y + height / 4.0f);
                    width = g.getFontMetrics().stringWidth("" + cmale);
                    g.setColor(Color.BLUE);
                    g.drawString("" + cmale, position.x - width / 2.0f - size / 4.0f, position.y + height / 4.0f);
                } else {
                    g.setColor(fill);
                    this.ellipse.setFrame(position.getX() - (double)size / 2.0 + 0.5, position.getY() - (double)size / 2.0 + 0.5, size - 1.0f, size - 1.0f);
                    g.fill(this.ellipse);
                    float width = g.getFontMetrics().stringWidth(nodeview.getNode().getNodeCount() + "");
                    float height = g.getFontMetrics().getHeight();
                    g.setColor(border);
                    g.drawString("" + nodeview.getNode().getNodeCount(), position.x - width / 2.0f, position.y + height / 4.0f);
                }
            } else {
                g.setColor(fill);
                this.ellipse.setFrame(position.getX() - (double)size / 2.0 + 0.5, position.getY() - (double)size / 2.0 + 0.5, size - 1.0f, size - 1.0f);
                g.fill(this.ellipse);
                int width = g.getFontMetrics().stringWidth("1");
                int height = g.getFontMetrics().getHeight();
                g.setColor(border);
                g.drawString("1", position.x - (float)width / 2.0f, position.y + (float)height / 4.0f);
            }
            g.setColor(border);
            g.draw(this.ellipse);
            g.setFont(oldfont);
        } else {
            g.setColor(fill);
            this.ellipse.setFrame(position.getX() - (double)size / 2.0 + 0.5, position.getY() - (double)size / 2.0 + 0.5, size - 1.0f, size - 1.0f);
            g.setColor(fill);
            this.ellipse.setFrame(position.getX() - (double)size / 2.0 + 0.5, position.getY() - (double)size / 2.0 + 0.5, size - 1.0f, size - 1.0f);
            g.fill(this.ellipse);
            g.setColor(border);
            g.draw(this.ellipse);
        }
    }

    public int getPriority() {
        return 0;
    }
}

