/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.rules;

import java.awt.Color;
import pedviz.view.NodeView;
import pedviz.view.rules.Rule;
import pedviz.view.symbols.SymbolFamily;

public class AbstractionRule
extends Rule {
    private int symbolmode = 0;
    private Object male = "2";
    private Object female = "1";
    public static final int NONE = 0;
    public static final int NUMBER = 1;
    public static final int NUMBER_2 = 2;

    public AbstractionRule(int mode, Object male, Object female) {
        this.male = male;
        this.female = female;
        this.symbolmode = mode;
    }

    public AbstractionRule(int mode) {
        this(mode, "2", "1");
    }

    public AbstractionRule() {
        this(0, "2", "1");
    }

    public void setSymbolMode(int symbolmode) {
        this.symbolmode = symbolmode;
    }

    public int getSymbolMode() {
        return this.symbolmode;
    }

    public void applyRule(NodeView nodeview) {
        if (nodeview.getNode().isDummy() && !nodeview.isExpand()) {
            nodeview.getSymbols().clear();
            nodeview.getSymbols().add(new SymbolFamily(this.symbolmode, this.male, this.female));
            String hint = "";
            for (NodeView node : nodeview.getNodes()) {
                hint = hint + node.getHint();
                if (!node.equals(nodeview.getNodes().get(nodeview.getNodes().size() - 1))) {
                    hint = hint + "\n{line}\n";
                }
                if (this.symbolmode != 0) continue;
                node.setSize(node.getSize() / 2.0f);
            }
            if (this.symbolmode == 0) {
                nodeview.setSize(nodeview.getSize() / 2.0f);
                nodeview.setColor(Color.DARK_GRAY);
                nodeview.setBorderColor(Color.DARK_GRAY);
            } else {
                nodeview.setColor(Color.WHITE);
                nodeview.setSize(nodeview.getSize() * 0.8f);
            }
            nodeview.setHintText(hint);
        } else if (!nodeview.isExpand()) {
            nodeview.getSymbols().clear();
            nodeview.getSymbols().add(new SymbolFamily(this.symbolmode, this.male, this.female));
            if (this.symbolmode == 0) {
                nodeview.setSize(nodeview.getSize() / 2.0f);
                nodeview.setColor(Color.DARK_GRAY);
                nodeview.setBorderColor(Color.DARK_GRAY);
            } else {
                nodeview.setColor(Color.WHITE);
                nodeview.setSize(nodeview.getSize() * 0.8f);
            }
        }
    }

    public Object getFemale() {
        return this.female;
    }

    public void setFemale(Object female) {
        this.female = female;
    }

    public Object getMale() {
        return this.male;
    }

    public void setMale(Object male) {
        this.male = male;
    }
}

