/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.effects;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import pedviz.view.effects.Effect;

public class FisheyeEffect
extends Effect {
    private float dx = 5.0f;
    private float dy = 5.0f;
    private float sz = 2.0f;
    private boolean m_distortX = false;
    private boolean m_distortY = false;
    private float minSize = 0.0f;

    public FisheyeEffect(float dx, float dy, float sz) {
        this.dx = dx;
        this.dy = dy;
        this.sz = sz;
        this.m_distortX = dx > 0.0f;
        this.m_distortY = dy > 0.0f;
    }

    public Point2D.Float transformPoint(float x, float y) {
        if (this.getFocus() == null | this.getBounds() == null) {
            return new Point2D.Float(x, y);
        }
        float newX = (float)this.distortX(x, this.getFocus(), this.getBounds());
        float newY = (float)this.distortY(y, this.getFocus(), this.getBounds());
        return new Point2D.Float(newX, newY);
    }

    public float transformSize(float size, float x, float y, float newX, float newY) {
        if (this.getFocus() == null | this.getBounds() == null) {
            return size;
        }
        Rectangle2D.Double box = new Rectangle2D.Double(x - size / 2.0f, y + size / 2.0f, size, size);
        return Math.max(this.minSize, size * (float)this.distortSize(box, newX, newY, this.getFocus(), this.getBounds()));
    }

    private double fisheye(double x, double a, double d, double min, double max) {
        if (d != 0.0) {
            double m;
            boolean left = x < a;
            double d2 = m = left ? a - min : max - a;
            if (m == 0.0) {
                m = max - min;
            }
            double v = Math.abs(x - a) / m;
            v = (d + 1.0) / (d + 1.0 / v);
            return (double)(left ? -1 : 1) * m * v + a;
        }
        return x;
    }

    protected double distortSize(Rectangle2D bbox, double x, double y, Point2D anchor, Rectangle2D bounds) {
        double sf;
        if (!this.m_distortX && !this.m_distortY) {
            return 1.0;
        }
        double fx = 1.0;
        double fy = 1.0;
        if (this.m_distortX) {
            double xx;
            double ax = anchor.getX();
            double minX = bbox.getMinX();
            double maxX = bbox.getMaxX();
            double d = xx = Math.abs(minX - ax) > Math.abs(maxX - ax) ? minX : maxX;
            if (xx < bounds.getMinX() || xx > bounds.getMaxX()) {
                xx = xx == minX ? maxX : minX;
            }
            fx = this.fisheye(xx, ax, this.dx, bounds.getMinX(), bounds.getMaxX());
            fx = Math.abs(x - fx) / bbox.getWidth();
        }
        if (this.m_distortY) {
            double yy;
            double ay = anchor.getY();
            double minY = bbox.getMinY();
            double maxY = bbox.getMaxY();
            double d = yy = Math.abs(minY - ay) > Math.abs(maxY - ay) ? minY : maxY;
            if (yy < bounds.getMinY() || yy > bounds.getMaxY()) {
                yy = yy == minY ? maxY : minY;
            }
            fy = this.fisheye(yy, ay, this.dy, bounds.getMinY(), bounds.getMaxY());
            fy = Math.abs(y - fy) / bbox.getHeight();
        }
        double d = !this.m_distortY ? fx : (sf = !this.m_distortX ? fy : Math.min(fx, fy));
        if (Double.isInfinite(sf) || Double.isNaN(sf)) {
            return 1.0;
        }
        return (double)this.sz * sf;
    }

    protected double distortX(double x, Point2D anchor, Rectangle2D bounds) {
        return this.fisheye(x, anchor.getX(), this.dx, bounds.getMinX(), bounds.getMaxX());
    }

    protected double distortY(double y, Point2D anchor, Rectangle2D bounds) {
        return this.fisheye(y, anchor.getY(), this.dy, bounds.getMinY(), bounds.getMaxY());
    }

    public float getMinSize() {
        return this.minSize;
    }

    public void setMinSize(float minSize) {
        this.minSize = minSize;
    }
}

