/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view.animations;

import java.awt.Color;
import java.util.Set;
import pedviz.graph.LayoutedGraph;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.GraphView;
import pedviz.view.animations.Animation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlinkAnimation
extends Animation {
    private Set<Node> nodes;
    private boolean blink = true;
    private Color background = Color.YELLOW;
    private Color border = Color.YELLOW;

    public BlinkAnimation(GraphView graphView, Set<Node> nodes, Color background, Color border) {
        this(graphView, nodes);
        this.background = background;
        this.border = border;
    }

    public BlinkAnimation(GraphView graphView, Set<Node> nodes) {
        super(graphView);
        this.nodes = nodes;
    }

    @Override
    public void pulse(GraphView graphView) {
        LayoutedGraph graph = graphView.getGraph();
        if (this.blink) {
            for (Node node : this.nodes) {
                Object mn = graph.getNodeView(node.getId());
                ((DefaultNodeView)mn).setBorderWidth(0.75f);
                ((DefaultNodeView)mn).setBorderColor(this.border);
                ((DefaultNodeView)mn).setColor(this.background);
            }
        } else {
            for (Node node : this.nodes) {
                Object mn = graph.getNodeView(node.getId());
                ((DefaultNodeView)mn).setBorderWidth(graph.getDefaultNodeView().getBorderWidth());
                ((DefaultNodeView)mn).setBorderColor(graph.getDefaultNodeView().getBorderColor());
                ((DefaultNodeView)mn).setColor(graph.getDefaultNodeView().getColor());
            }
        }
        this.blink = !this.blink;
        graphView.updateNodes(this.nodes);
    }

    @Override
    public void stop() {
        super.stop();
        LayoutedGraph graph = this.graphView.getGraph();
        for (Node node : this.nodes) {
            Object mn = graph.getNodeView(node.getId());
            ((DefaultNodeView)mn).setBorderWidth(graph.getDefaultNodeView().getBorderWidth());
            ((DefaultNodeView)mn).setBorderColor(graph.getDefaultNodeView().getBorderColor());
            ((DefaultNodeView)mn).setColor(graph.getDefaultNodeView().getColor());
        }
        this.graphView.updateNodes(this.nodes);
    }
}

