/*
 * Decompiled with CFR 0.152.
 */
package pedviz.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;
import pedviz.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RessourceGraphLoader
extends Loader {
    private String filename;
    private String separator;
    private String[] colStrings;
    private ArrayList<String> attributes;
    private HashMap<String, Integer> types;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;

    public RessourceGraphLoader(String filename, String separator) {
        this.filename = filename;
        this.separator = separator;
        this.attributes = new ArrayList();
        this.types = new HashMap();
    }

    public void setColumnType(String column, int type) {
        this.types.put(column, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Graph graph) {
        int colId = -1;
        int colIdMom = -1;
        int colIdDad = -1;
        BufferedReader reader = null;
        Object fis = null;
        ArrayList<Object[]> myEdges = new ArrayList<Object[]>();
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.filename)));
            String row = reader.readLine();
            this.colStrings = row.split(this.separator);
            for (int i = 0; i < this.colStrings.length; ++i) {
                String colString = this.colStrings[i].toUpperCase();
                if (colString.equals(this.getIdColumn().toUpperCase())) {
                    colId = i;
                }
                if (colString.equals(this.getMomColumn().toUpperCase())) {
                    colIdMom = i;
                }
                if (colString.equals(this.getDadColumn().toUpperCase())) {
                    colIdDad = i;
                }
                this.attributes.add(colString);
            }
            while ((row = reader.readLine()) != null) {
                String[] columns = row.split(this.separator);
                String id = null;
                String idMom = null;
                String idDad = null;
                id = columns[colId];
                if (!columns[colIdMom].equals("")) {
                    idMom = columns[colIdMom];
                }
                if (!columns[colIdDad].equals("")) {
                    idDad = columns[colIdDad];
                }
                Node node = new Node(id);
                node.setIdDad(idDad);
                node.setIdMom(idMom);
                myEdges.add(new Object[]{idDad, id});
                myEdges.add(new Object[]{idMom, id});
                graph.addNode(node);
                for (int i = 0; i < columns.length; ++i) {
                    String value = columns[i];
                    if (i == colIdMom) {
                        node.setUserData(this.colStrings[i], idMom);
                        continue;
                    }
                    if (i == colIdDad) {
                        node.setUserData(this.colStrings[i], idDad);
                        continue;
                    }
                    Integer type = this.types.get(this.colStrings[i]);
                    if (type != null) {
                        switch (type) {
                            case 0: {
                                node.setUserData(this.colStrings[i], Integer.parseInt(value));
                                break;
                            }
                            case 1: {
                                node.setUserData(this.colStrings[i], Double.parseDouble(value));
                                break;
                            }
                            default: {
                                node.setUserData(this.colStrings[i], value);
                                break;
                            }
                        }
                        continue;
                    }
                    node.setUserData(this.colStrings[i], value);
                }
            }
            for (Object[] edge : myEdges) {
                Node start = graph.getNode(edge[0]);
                Node end = graph.getNode(edge[1]);
                if (start == null || end == null) continue;
                Edge edge2 = new Edge(start, end);
                graph.addEdge(edge2);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<String> getColumns() {
        Vector<String> colStrings = new Vector<String>();
        BufferedReader reader = null;
        try {
            String[] tiles;
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.filename)));
            String row = reader.readLine();
            for (String tile : tiles = row.split(this.separator)) {
                colStrings.add(tile);
            }
        }
        catch (Exception e) {
            System.out.println("......." + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
        return colStrings;
    }
}

