/*
 * Decompiled with CFR 0.152.
 */
package pedviz.graph;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import pedviz.algorithms.HierarchieBuilder;
import pedviz.graph.Cluster;
import pedviz.graph.Edge;
import pedviz.graph.Hierarchy;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    private HashMap<Object, Node> nodes = new HashMap();
    private HashMap<Object, Node> subnodes = new HashMap();
    private ArrayList<Edge> edges = new ArrayList();
    private int countId = -2;
    private boolean layouted = false;
    private ArrayList<Hierarchy> hierachies = new ArrayList();
    private String name = "noname";

    public Graph() {
    }

    public Graph(Cluster cluster) {
        this();
        for (Node node : cluster.getNodes()) {
            this.addNode(node);
            for (Node subNode : node.getNodes()) {
                this.subnodes.put(subNode.getId(), subNode);
            }
        }
        for (Edge edge : cluster.getEdges()) {
            this.addEdge(edge);
        }
        for (Node node : cluster.getNodes()) {
            if (node.getInDegree() + node.getOutDegree() != 0) continue;
            this.removeNode(node);
        }
    }

    public void addNode(Node node) {
        this.nodes.put(node.getId(), node);
    }

    public Node getNode(Object id) {
        if (id == null) {
            return null;
        }
        Node result = this.nodes.get(id);
        if (result == null) {
            result = this.subnodes.get(id);
        }
        return result;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
        edge.getStart().addOutEdge(edge);
        edge.getEnd().addInEdge(edge);
    }

    public void addEdge(Edge edge, boolean updateNodes) {
        if (!updateNodes) {
            this.edges.add(edge);
        } else {
            this.addEdge(edge);
        }
    }

    public void removeNode(Node node) {
        if (node.getParent() == null) {
            for (Edge edge : node.getInEdges()) {
                this.edges.remove(edge);
                edge.getStart().removeOutEdge(edge);
            }
            for (Edge edge : node.getOutEdges()) {
                this.edges.remove(edge);
                edge.getEnd().removeInEdge(edge);
            }
            node.getInEdges().clear();
            node.getOutEdges().clear();
            this.subnodes.values().removeAll(node.getNodes());
            if (node.getHierarchy() != null) {
                node.getHierarchy().removeNode(node);
            }
            this.nodes.values().remove(node);
        } else {
            this.removeNode(node.getParent());
        }
    }

    public void removeNode(Node node, boolean updateNode) {
        if (!updateNode) {
            for (Edge edge : node.getInEdges()) {
                this.edges.remove(edge);
                edge.getStart().removeOutEdge(edge);
            }
            for (Edge edge : node.getOutEdges()) {
                this.edges.remove(edge);
                edge.getEnd().removeInEdge(edge);
            }
            this.nodes.values().remove(node);
        } else {
            this.removeNode(node);
        }
    }

    public void removeEdge(Edge edge) {
        edge.getStart().removeOutEdge(edge);
        edge.getEnd().removeInEdge(edge);
        this.edges.remove(edge);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Collection<Node> getAllNodes() {
        Vector<Node> result = new Vector<Node>();
        result.addAll(this.nodes.values());
        result.addAll(this.subnodes.values());
        return result;
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    public int getFreeId() {
        return this.countId--;
    }

    public void addNode(Node parent, Node node) {
        node.setParent(parent);
        parent.addNode(node);
        for (Edge edge : node.getOutEdges()) {
            Edge newEdge = new Edge(parent, edge.getEnd());
            this.addEdge(newEdge);
        }
        for (Edge edge : node.getInEdges()) {
            this.edges.remove(edge);
            edge.getStart().removeOutEdge(edge);
        }
        node.getInEdges().clear();
        this.subnodes.put(node.getId(), node);
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.subnodes.clear();
    }

    public boolean isLayouted() {
        return this.layouted;
    }

    public void setLayouted(boolean layouted) {
        this.layouted = layouted;
    }

    public void exportAsCsvFile(String filename) {
        BufferedWriter out = null;
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("fam".toUpperCase());
        temp.add("pid".toUpperCase());
        temp.add("dad".toUpperCase());
        temp.add("mom".toUpperCase());
        temp.add("sex".toUpperCase());
        try {
            out = new BufferedWriter(new FileWriter(filename));
            Object[] columns = null;
            for (Node node : this.getAllNodes()) {
                if (node.isDummy()) continue;
                if (columns == null) {
                    columns = node.getUserDataList();
                    String firstLine = "";
                    ArrayList temp2 = (ArrayList)temp.clone();
                    for (String column : temp2) {
                        if (node.getUserData(column) != null) continue;
                        temp.remove(column);
                    }
                    temp2.clear();
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        if (temp.contains(column)) continue;
                        temp.add(column.toString());
                    }
                    for (String column : temp) {
                        if (!firstLine.equals("")) {
                            firstLine = firstLine + ",";
                        }
                        firstLine = firstLine + column.toString();
                    }
                    out.write(firstLine + "\n");
                }
                String nodeLine = "";
                for (String column : temp) {
                    if (!nodeLine.equals("")) {
                        nodeLine = nodeLine + ",";
                    }
                    nodeLine = nodeLine + node.getUserData(column.toString());
                }
                out.write(nodeLine + "\n");
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeAllHierachies() {
        this.hierachies.clear();
    }

    public Hierarchy getHierachy(int id) {
        return this.hierachies.get(id);
    }

    public int getHierachiesCount() {
        return this.hierachies.size();
    }

    public int getHierachiesDepth() {
        int max = 0;
        for (int i = 0; i < this.hierachies.size(); ++i) {
            if (max >= this.hierachies.get(i).getNodes().size()) continue;
            max = this.hierachies.get(i).getNodes().size();
        }
        return max;
    }

    protected void addHierarchy(Hierarchy hierachie) {
        this.hierachies.add(hierachie);
    }

    public void buildHierarchie(HierarchieBuilder builder) {
        builder.buildHirarchie(this);
    }

    public String toString() {
        return this.name;
    }

    public int getSize() {
        int count = 0;
        for (Node node : this.getAllNodes()) {
            if (node.isDummy()) continue;
            ++count;
        }
        return count;
    }

    public void print() {
        System.out.println("Name: " + this.getName());
        System.out.println("AllNodes: " + this.getAllNodes().size());
        System.out.println("Nodes: " + this.getNodes().size());
        System.out.println("SubNodes: " + this.subnodes.size());
        for (Edge edge : this.edges) {
            System.out.println(edge);
        }
    }
}

