/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.filter;

import java.util.ArrayList;
import java.util.Vector;
import pedviz.algorithms.filter.Condition;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private Vector<Condition> conditions = new Vector();
    public static final int AND = 0;
    public static final int OR = 1;
    private int operator = 1;

    public Filter() {
    }

    public Filter(int operator) {
        this.operator = operator;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public ArrayList<Node> execute(Graph graph) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : graph.getAllNodes()) {
            if (node.isDummy()) continue;
            boolean temp = false;
            if (this.operator == 0) {
                temp = true;
            }
            for (Condition condition : this.conditions) {
                if (condition.check(node)) {
                    if (this.operator == 0) {
                        temp &= true;
                    }
                    if (this.operator != 1) continue;
                    temp |= true;
                    continue;
                }
                if (this.operator != 0) continue;
                temp = false;
            }
            if (!temp) continue;
            result.add(node);
        }
        return result;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }
}

