/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import pedviz.algorithms.HierarchieUpDown;
import pedviz.graph.Cluster;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAlgo {
    public static Vector<Graph> createGraphs(Graph graph, Vector<Node> nodes, int max) {
        Vector<Graph> result = new Vector<Graph>();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            HashSet<Node> temp = new HashSet<Node>();
            Set<Node> parents = TestAlgo.getParents(graph, node, 1, max);
            temp.addAll(parents);
            for (Node parent : parents) {
                temp.addAll(parent.getChilds());
            }
            Cluster cluster = new Cluster(temp);
            Graph subgraph = new Graph(cluster);
            int count = 0;
            for (Node n : nodes) {
                if (subgraph.getNode(n.getId()) == null) continue;
                ++count;
            }
            subgraph.setName("Family_" + i + " (" + count + "/" + subgraph.getSize() + ")");
            subgraph.buildHierarchie(new HierarchieUpDown());
            result.add(subgraph);
        }
        return result;
    }

    public static Set<Node> getParents(Graph graph, Node node, int current, int max) {
        HashSet<Node> result = new HashSet<Node>();
        Node mom = graph.getNode(node.getIdMom());
        Node dad = graph.getNode(node.getIdDad());
        if (mom == null && dad == null) {
            result.add(node);
        } else if (current == max) {
            if (mom != null) {
                result.add(mom);
            }
            if (dad != null) {
                result.add(dad);
            }
        } else {
            if (mom != null) {
                result.addAll(TestAlgo.getParents(graph, mom, current + 1, max));
            }
            if (dad != null) {
                result.addAll(TestAlgo.getParents(graph, dad, current + 1, max));
            }
        }
        return result;
    }
}

