/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.Algorithm;
import pedviz.algorithms.HierarchieUpDown;
import pedviz.algorithms.RubberBands;
import pedviz.algorithms.SameParents;
import pedviz.algorithms.sugiyama.Splitter;
import pedviz.algorithms.sugiyama.SugiyamaLayout;
import pedviz.graph.Graph;
import pedviz.graph.LayoutedGraph;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;

public class Sugiyama
implements Algorithm,
ChangeListener {
    private LayoutedGraph layoutedGraph;
    private RubberBands rubberBands;
    private SameParents sameParents;
    private SugiyamaLayout layout;
    private Vector<Algorithm> algorithms = new Vector();
    String message = "";
    int i = 0;
    int percent = 0;
    ChangeListener changeListener;

    public Sugiyama(Graph graph) {
        this(graph, new DefaultNodeView(), new DefaultEdgeView());
    }

    public Sugiyama(Graph graph, Splitter splitter) {
        this(graph, new DefaultNodeView(), new DefaultEdgeView(), splitter);
    }

    public Sugiyama(Graph graph, DefaultNodeView defaultNodeView, DefaultEdgeView defaultEdgeView) {
        this(graph, defaultNodeView, defaultEdgeView, null);
    }

    public Sugiyama(Graph graph, DefaultNodeView defaultNodeView, DefaultEdgeView defaultEdgeView, Splitter splitter) {
        this.sameParents = new SameParents(graph);
        this.sameParents.addChangeListener(this);
        this.message = "SameParents";
        this.sameParents.run();
        graph.buildHierarchie(new HierarchieUpDown());
        this.layout = new SugiyamaLayout(graph, defaultNodeView, defaultEdgeView);
        this.layout.addChangeListener(this);
        if (splitter != null) {
            this.layout.setSplitter(splitter);
        }
        this.algorithms.add(this.layout);
        this.layoutedGraph = this.layout.getLayoutGraph();
        this.rubberBands = new RubberBands(this.layoutedGraph);
        this.rubberBands.addChangeListener(this);
        this.algorithms.add(this.rubberBands);
    }

    public LayoutedGraph getLayoutedGraph() {
        return this.layoutedGraph;
    }

    public String getMessage() {
        return this.message;
    }

    public void run() {
        this.i = 0;
        this.message = this.layout.getMessage();
        this.layout.run();
        this.i = 1;
        this.message = this.rubberBands.getMessage();
        this.rubberBands.run();
        System.out.println("tet");
    }

    public void stateChanged(ChangeEvent e) {
        try {
            this.fireChangeListener(Math.round(this.algorithms.get(this.i).getPercentComplete()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fireChangeListener(int percent) {
        if (this.changeListener != null) {
            this.percent = percent;
            this.changeListener.stateChanged(null);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public int getPercentComplete() {
        return this.percent;
    }

    public SugiyamaLayout getLayout() {
        return this.layout;
    }

    public RubberBands getRubberBands() {
        return this.rubberBands;
    }
}

