/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.Algorithm;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameParents
implements Algorithm {
    Graph graph;
    ArrayList<Graph> graphs;
    ChangeListener changeListener;
    int percent = 0;

    public SameParents(Graph graph) {
        this.graph = graph;
    }

    public SameParents(ArrayList<Graph> graphs) {
        this.graphs = graphs;
    }

    @Override
    public String getMessage() {
        return "search nodes with same parents";
    }

    @Override
    public void run() {
        if (this.graph != null) {
            this.clusterNodesWithSameParents(this.graph);
        }
        if (this.graphs != null) {
            for (Graph graph : this.graphs) {
                this.clusterNodesWithSameParents(graph);
            }
        }
    }

    private void clusterNodesWithSameParents(Graph graph) {
        HashMap families = new HashMap();
        int total = graph.getNodes().size();
        int current = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(graph.getNodes());
        for (Node node : nodes) {
            this.fireChangeListener(Math.round(current * 100 / total));
            ++current;
            if (node.getInDegree() <= 0) continue;
            HashSet<Object> currentSet = new HashSet<Object>();
            currentSet.add(node.getIdDad());
            currentSet.add(node.getIdMom());
            if (families.containsKey(currentSet)) {
                Node cluster = (Node)families.get(currentSet);
                if (!cluster.isDummy()) {
                    Node dummy = new Node("" + graph.getFreeId());
                    dummy.setDummy(true);
                    dummy.setIdMom(cluster.getIdMom());
                    dummy.setIdDad(cluster.getIdDad());
                    graph.addNode(dummy);
                    for (Edge edge : cluster.getInEdges()) {
                        graph.addEdge(new Edge(edge.getStart(), dummy));
                    }
                    graph.addNode(dummy, cluster);
                    graph.addNode(dummy, node);
                    graph.removeNode(node, false);
                    graph.removeNode(cluster, false);
                    families.put(currentSet, dummy);
                    continue;
                }
                graph.addNode(cluster, node);
                graph.removeNode(node, false);
                continue;
            }
            families.put(currentSet, node);
        }
        nodes.clear();
    }

    @Override
    public int getPercentComplete() {
        return this.percent;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    private void fireChangeListener(int percent) {
        if (this.changeListener != null) {
            this.percent = percent;
            this.changeListener.stateChanged(null);
        }
    }
}

