/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Highlighter {
    public static final int MATERNAL = 2;
    public static final int PATERNAL = 4;
    public static final int MATERNAL_AND_PATERNAL = 8;
    public static final int SUCCESSORS = 16;
    public static final int ANCESTORS = 32;
    public static final int SUCCESSORS_AND_ANCESTORS = 64;

    public static ArrayList<Node> findPath(Node nodeA, Node nodeB) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeA != null && nodeB != null) {
            Set<Node> parentsA = nodeA.getParents();
            Set<Node> parentsB = nodeB.getParents();
            if (parentsA.contains(nodeB)) {
                result.add(nodeB);
                result.add(nodeA);
                for (Node node : nodeA.getPathTo(nodeB)) {
                    result.add(node);
                }
                return result;
            }
            if (parentsB.contains(nodeA)) {
                result.add(nodeB);
                result.add(nodeA);
                for (Node node : nodeB.getPathTo(nodeA)) {
                    result.add(node);
                }
                return result;
            }
            HashSet<Node> parents = new HashSet<Node>();
            parents.addAll(parentsA);
            parents.retainAll(parentsB);
            if (parents.size() > 0) {
                result.add(nodeA);
                result.add(nodeB);
                Node destination = null;
                int level = -1;
                for (Node parent : parents) {
                    if (parent.getLevel() <= level || parent.isDummy()) continue;
                    destination = parent;
                    level = parent.getLevel();
                }
                for (Node parent : parents) {
                    if (parent.getLevel() != level) continue;
                    result.add(parent);
                    if (!parent.isDummy() || parent.getNodeCount() != 0) continue;
                    Set<Node> dummies = parent.getParents(1);
                    for (Node dummy : dummies) {
                        result.add(dummy);
                    }
                }
                for (Node node : nodeA.getPathTo(destination)) {
                    result.add(node);
                }
                for (Node node : nodeB.getPathTo(destination)) {
                    result.add(node);
                }
                return result;
            }
        }
        return null;
    }

    public static ArrayList<Node> findParentsAndChilds(Node node, int max) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(node);
        for (Node parents : node.getParentsAndChilds(max)) {
            result.add(parents);
        }
        return result;
    }

    public static ArrayList<Node> findParentsAndChilds(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(node);
        for (Node parents : node.getParentsAndChilds()) {
            result.add(parents);
        }
        return result;
    }

    public static ArrayList<Node> findLineOfDescents(Graph graph, Node node, int mode) {
        Node newDummie;
        Node dummie;
        int level;
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(node);
        if (mode == 16 || mode == 64) {
            result.addAll(node.getChilds());
        }
        if (mode == 32 || mode == 64) {
            result.addAll(node.getParents());
        }
        if (mode == 2 || mode == 8) {
            level = node.getLevel();
            Node mom = graph.getNode(node.getIdMom());
            while (mom != null) {
                result.add(mom);
                if (mom != null && mom.getLevel() + 1 < level) {
                    dummie = null;
                    for (Edge out : mom.getOutEdges()) {
                        if (!out.getEnd().isDummy()) continue;
                        dummie = out.getEnd();
                    }
                    while (dummie != null) {
                        result.add(dummie);
                        newDummie = null;
                        for (Edge out : dummie.getOutEdges()) {
                            if (!out.getEnd().isDummy()) continue;
                            newDummie = out.getEnd();
                        }
                        dummie = newDummie;
                    }
                }
                mom = graph.getNode(mom.getIdMom());
            }
        }
        if (mode == 4 || mode == 8) {
            level = node.getLevel();
            Node dad = graph.getNode(node.getIdDad());
            while (dad != null) {
                result.add(dad);
                if (dad != null && dad.getLevel() + 1 < level) {
                    dummie = null;
                    for (Edge out : dad.getOutEdges()) {
                        if (!out.getEnd().isDummy()) continue;
                        dummie = out.getEnd();
                    }
                    while (dummie != null) {
                        result.add(dummie);
                        newDummie = null;
                        for (Edge out : dummie.getOutEdges()) {
                            if (!out.getEnd().isDummy()) continue;
                            newDummie = out.getEnd();
                        }
                        dummie = newDummie;
                    }
                }
                dad = graph.getNode(dad.getIdDad());
            }
        }
        return result;
    }
}

