/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import pedviz.algorithms.HierarchieBuilder;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Hierarchy;
import pedviz.graph.Node;

public class HierarchieUpDown
implements HierarchieBuilder {
    public void buildHirarchie(Graph graph) {
        graph.removeAllHierachies();
        Hierarchy hierachie = new Hierarchy(graph);
        for (Node node : graph.getNodes()) {
            if (node.getInDegree() == 0) {
                hierachie.addNode(0, node);
                continue;
            }
            hierachie.addNode(-1, node);
        }
        int currentLayer = 0;
        ArrayList<Node> currentNodes = hierachie.getNodes(0);
        while (currentNodes != null) {
            ArrayList<Integer> newNodesLayer = new ArrayList<Integer>();
            ArrayList<Node> newNode = new ArrayList<Node>();
            for (Node node : currentNodes) {
                for (Edge pre : node.getInEdges()) {
                    if (pre.getStart().getLevel() < currentLayer) continue;
                    newNode.add(node);
                    newNodesLayer.add(currentLayer + 1);
                }
                for (Edge pre : node.getOutEdges()) {
                    Node end = pre.getEnd();
                    if (end.getLevel() > currentLayer) continue;
                    newNode.add(end);
                    newNodesLayer.add(currentLayer + 1);
                }
            }
            for (int i = 0; i < newNode.size(); ++i) {
                hierachie.addNode((Integer)newNodesLayer.get(i), (Node)newNode.get(i));
            }
            currentNodes = hierachie.getNodes(currentLayer);
            ++currentLayer;
            for (Node node : currentNodes) {
                for (Edge outEdge : node.getOutEdges()) {
                    Node parent = outEdge.getEnd();
                    int maxLayer = -1;
                    for (Edge pre : parent.getInEdges()) {
                        Node start = pre.getStart();
                        if (start.getLevel() <= maxLayer) continue;
                        maxLayer = start.getLevel();
                    }
                    if (parent.getLevel() >= 0 || maxLayer >= currentLayer) continue;
                    hierachie.addNode(currentLayer, parent);
                }
            }
            currentNodes = hierachie.getNodes(currentLayer);
        }
        this.shuffle(graph, 0);
        for (int i = 0; i < graph.getHierachiesCount(); ++i) {
            this.insertDummyNodes(graph, i);
        }
    }

    private void shuffle(Graph graph, int id) {
        for (int i = 0; i < graph.getHierachiesDepth(); ++i) {
            ArrayList<Node> layer = graph.getHierachy(id).getNodes(i);
            if (layer == null) continue;
            Collections.shuffle(layer);
        }
    }

    private void insertDummyNodes(Graph graph, int id) {
        Hierarchy hierarchie = graph.getHierachy(id);
        for (int i = 0; i < graph.getHierachiesDepth() - 1; ++i) {
            ArrayList<Node> currentNodes = hierarchie.getNodes(i);
            if (currentNodes == null) continue;
            ArrayList copyOfCurrentNodes = (ArrayList)currentNodes.clone();
            for (Node node : copyOfCurrentNodes) {
                ArrayList copyOfEdges = (ArrayList)node.getOutEdges().clone();
                for (Edge in : copyOfEdges) {
                    Node end = in.getEnd();
                    if (end.getLevel() - i <= 1) continue;
                    if (node.getInDegree() == 0) {
                        hierarchie.addNode(i + 1, node);
                        continue;
                    }
                    Node dummy = new Node(graph.getFreeId());
                    dummy.setDummy(true);
                    dummy.setIdMom(in.getEnd().getIdMom());
                    dummy.setIdDad(in.getEnd().getIdDad());
                    graph.addNode(dummy);
                    hierarchie.addNode(i + 1, dummy);
                    graph.addEdge(new Edge(node, dummy));
                    graph.addEdge(new Edge(dummy, in.getEnd()));
                    graph.removeEdge(in);
                }
                copyOfEdges.clear();
            }
            copyOfCurrentNodes.clear();
        }
    }
}

