/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.ArrayList;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphRepair {
    public static Vector<String> repair(Graph graph) {
        return GraphRepair.insertMissingParents(graph, (Object)"1", (Object)"2");
    }

    public static Vector<String> insertMissingParents(Graph graph, Object male, Object female) {
        Vector<Graph> graphs = new Vector<Graph>();
        graphs.add(graph);
        return GraphRepair.insertMissingParents(graphs, male, female);
    }

    public static Vector<String> insertMissingParents(Vector<Graph> graphs) {
        return GraphRepair.insertMissingParents(graphs, (Object)"1", (Object)"2");
    }

    public static Vector<String> insertMissingParents(Vector<Graph> graphs, Object male, Object female) {
        Vector<String> log = new Vector<String>();
        for (Graph graph : graphs) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(graph.getNodes());
            for (Node node : nodes) {
                Node dad;
                Node mom;
                if (node.isDummy() && (!node.isDummy() || node.getNodes().size() <= 0)) continue;
                String id = node.getId().toString();
                if (node.getNodeCount() > 0) {
                    id = "";
                    for (Node subNode : node.getNodes()) {
                        id = id + subNode.getId().toString();
                        if (node.getNodes().indexOf(subNode) >= node.getNodeCount() - 1) continue;
                        id = id + ", ";
                    }
                }
                if (node.getInDegree() == 0 && node.getOutDegree() == 0) {
                    graph.removeNode(node);
                }
                if (node.getInDegree() == 1) {
                    if (graph.getNode(node.getIdMom()) == null) {
                        mom = new Node("##" + node.getId());
                        mom.setUserData("PID", "##" + node.getId());
                        mom.setUserData("sex", female);
                        mom.setUserData("virtual", "1");
                        graph.addNode(mom);
                        graph.addEdge(new Edge(mom, node));
                        log.add(graph.getName() + ": Add mom for node [" + id + "]");
                    }
                    if (graph.getNode(node.getIdDad()) == null) {
                        Node dad2 = new Node("##" + node.getId());
                        dad2.setUserData("PID", "##" + node.getId());
                        dad2.setUserData("sex", male);
                        dad2.setUserData("virtual", "1");
                        graph.addNode(dad2);
                        graph.addEdge(new Edge(dad2, node));
                        log.add(graph.getName() + ": Add dad for node [" + id + "]");
                    }
                }
                if ((mom = graph.getNode(node.getIdMom())) != null && !mom.getUserData("sex").equals(female)) {
                    mom.setUserData("sex", female);
                    log.add(graph.getName() + ": Change sex of node [" + mom.getId() + "]");
                }
                if ((dad = graph.getNode(node.getIdDad())) == null || dad.getUserData("sex").equals(male)) continue;
                dad.setUserData("sex", male);
                log.add(graph.getName() + ": Change sex of node [" + dad.getId() + "]");
            }
            nodes.clear();
        }
        return log;
    }
}

