/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.Vector;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphError
implements Comparable {
    public static final int INVALID_SEX_MOM = 0;
    public static final int INVALID_SEX_DAD = 1;
    public static final int SINGLETON = 2;
    public static final int MISSING_MOM = 3;
    public static final int MISSING_DAD = 4;
    public static final int MULTI_PEDIGREES = 5;
    public static String[] errorMessages = new String[]{"mom has invalid sex.", "dad has invalid sex.", "singleton.", "mom is missing.", "dad is missing.", ""};
    private int type;
    private boolean multipleNodes = false;
    private Vector<Node> nodes;
    private String message;

    public GraphError(int type, Vector<Node> nodes) {
        this.nodes = nodes;
        this.type = type;
        this.multipleNodes = nodes.size() > 1;
        this.message = errorMessages[type];
    }

    public GraphError(int type, Node node) {
        this.nodes = new Vector();
        if (node.getNodeCount() > 0) {
            this.nodes.addAll(node.getNodes());
        } else {
            this.nodes.add(node);
        }
        this.multipleNodes = false;
        this.type = type;
        this.message = errorMessages[type];
    }

    public GraphError(int type, Node node, String message) {
        this.nodes = new Vector();
        if (node.getNodeCount() > 0) {
            this.nodes.addAll(node.getNodes());
        } else {
            this.nodes.add(node);
        }
        this.multipleNodes = false;
        this.type = type;
        this.message = message;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMultipleNodes() {
        return this.multipleNodes;
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    public String toString() {
        String nodesT = "";
        for (Node node : this.nodes) {
            nodesT = nodesT + node.getId().toString();
            if (this.nodes.lastElement().equals(node)) continue;
            nodesT = nodesT + ", ";
        }
        return "[" + nodesT + "]: " + this.message;
    }

    public int compareTo(Object arg0) {
        GraphError error = (GraphError)arg0;
        if (error.getNodes().equals(this.getNodes())) {
            return 0;
        }
        return new Integer(this.getNodes().size()).compareTo(error.getNodes().size());
    }
}

