/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms;

import java.util.Collections;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.Algorithm;
import pedviz.algorithms.GraphError;
import pedviz.graph.Graph;
import pedviz.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorChecking
implements Algorithm {
    private Vector<Graph> graphs;
    private Vector<GraphError> errors;
    private Object male;
    private Object female;

    public ErrorChecking(Graph graph) {
        this(graph, (Object)"1", (Object)"2");
    }

    public ErrorChecking(Graph graph, Object male, Object female) {
        this.graphs = new Vector();
        this.graphs.add(graph);
        this.errors = new Vector();
        this.male = male;
        this.female = female;
    }

    public ErrorChecking(Vector<Graph> graphs, Object male, Object female) {
        this.graphs = graphs;
        this.errors = new Vector();
        this.male = male;
        this.female = female;
    }

    public ErrorChecking(Vector<Graph> graphs) {
        this(graphs, (Object)"1", (Object)"2");
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public String getMessage() {
        return "Error Checking";
    }

    @Override
    public int getPercentComplete() {
        return 0;
    }

    @Override
    public void run() {
        this.errors.clear();
        for (Graph graph : this.graphs) {
            for (Node node : graph.getNodes()) {
                Node dad;
                Node mom;
                if (node.isDummy() && (!node.isDummy() || node.getNodes().size() <= 0)) continue;
                if (node.getInDegree() == 0 && node.getOutDegree() == 0) {
                    this.errors.add(new GraphError(2, node));
                }
                if (node.getInDegree() == 1) {
                    if (graph.getNode(node.getIdDad()) == null) {
                        this.errors.add(new GraphError(4, node));
                    }
                    if (graph.getNode(node.getIdMom()) == null) {
                        this.errors.add(new GraphError(3, node));
                    }
                }
                if ((mom = graph.getNode(node.getIdMom())) != null && !mom.getUserData("sex").equals(this.female)) {
                    this.errors.add(new GraphError(0, node));
                }
                if ((dad = graph.getNode(node.getIdDad())) == null || dad.getUserData("sex").equals(this.male)) continue;
                this.errors.add(new GraphError(1, node));
            }
        }
    }

    public Vector<GraphError> getErrors() {
        Collections.sort(this.errors);
        return this.errors;
    }
}

