/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.appdevapi;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ut.biolab.medsavant.shared.appdevapi.VariantIterator;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;

public class Variant {
    private static final String JANNOVAR_EFFECT = BasicVariantColumns.JANNOVAR_EFFECT.getColumnName();
    private static final String JANNOVAR_SYMBOL = BasicVariantColumns.JANNOVAR_SYMBOL.getColumnName();
    private static final String DP4 = "DP4";
    private static final String AD = "AD";
    private static final String AO = "AO";
    private static final String DP = "DP";
    private static final String GT = "GT";
    private static final Pattern geneSymbolPattern = Pattern.compile("^([^:]+)");
    private static final String VCF_MISSING_VALUE = ".";
    private Object[] row;
    private String chromosome;
    private String reference;
    private String alternate;
    private int alternateNumber;
    private long start;
    private long end;
    private String zygosity;
    private int alternateDepth = -1;
    private int referenceDepth = -1;
    private String geneSymbol;
    private String infoColumn;
    private String formatColumn;
    private String sampleInfoColumn;
    private String gtField;
    private String variantEffect;
    private String variantType;

    public Variant(Object[] currentRow) {
        this.row = currentRow;
        this.chromosome = (String)this.row[4];
        this.reference = (String)this.row[8];
        this.alternate = (String)this.row[9];
        this.alternateNumber = (Integer)this.row[10];
        this.start = ((Integer)this.row[5]).longValue();
        this.end = ((Integer)this.row[6]).longValue();
        this.zygosity = (String)this.row[14];
        this.infoColumn = (String)this.row[16];
        this.formatColumn = this.extractFromInfoColumn(BasicVariantColumns.FORMAT.getColumnName());
        this.sampleInfoColumn = this.extractFromInfoColumn(BasicVariantColumns.SAMPLE_INFO.getColumnName());
    }

    public int getAlternateDepth() {
        try {
            if (this.alternateDepth == -1) {
                this.extractCoverage();
            }
        }
        catch (FieldNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
            fnfe.printStackTrace();
        }
        return this.alternateDepth;
    }

    public int getReferenceDepth() {
        try {
            if (this.referenceDepth == -1) {
                this.extractCoverage();
            }
        }
        catch (FieldNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
            fnfe.printStackTrace();
        }
        return this.referenceDepth;
    }

    public String getReference() {
        return this.reference;
    }

    public String getAlternate() {
        return this.alternate;
    }

    public int getAlternateNumber() {
        return this.alternateNumber;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getGene() {
        if (this.geneSymbol == null) {
            this.extractGene();
        }
        return this.geneSymbol;
    }

    public String getGT() {
        try {
            if (this.gtField == null) {
                this.gtField = this.extractFromFormatColumn(GT);
            }
        }
        catch (FieldNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
            fnfe.printStackTrace();
        }
        return this.gtField;
    }

    public String getMutationSymbols() {
        if (this.variantEffect == null) {
            this.variantEffect = this.extractFromInfoColumn(JANNOVAR_SYMBOL);
        }
        return this.variantEffect;
    }

    public String getMutationType() {
        if (this.variantType == null) {
            this.variantType = this.extractFromInfoColumn(JANNOVAR_EFFECT);
        }
        return this.variantType;
    }

    public String getZygosity() {
        return this.zygosity;
    }

    public Object getColumn(String columnName) {
        int index = VariantIterator.header.indexOf(columnName);
        return this.row[index];
    }

    public Object[] getRow() {
        return this.row;
    }

    public List<String> getHeader() {
        return VariantIterator.header;
    }

    public String extractFromInfoColumn(String key) {
        String regex = ";?" + key + "=([^;]+);?";
        Pattern keyPattern = Pattern.compile(regex, 2);
        Matcher keyMatcher = keyPattern.matcher(this.infoColumn);
        String value = null;
        if (keyMatcher.find()) {
            value = keyMatcher.group(1);
        }
        return value;
    }

    public String extractFromFormatColumn(String key) throws FieldNotFoundException {
        List<String> formatKeys = Arrays.asList(this.formatColumn.split(":"));
        int index = formatKeys.indexOf(key);
        List<String> sampleInfoKeys = Arrays.asList(this.sampleInfoColumn.split(":"));
        if (formatKeys.size() != sampleInfoKeys.size()) {
            throw new FieldNotFoundException("FORMAT and SAMPLE_INFO columns have a different number of fields; should be identical size.");
        }
        String value = null;
        if (index != -1) {
            value = sampleInfoKeys.get(index);
        }
        return value;
    }

    private void extractGene() {
        String geneString = this.extractFromInfoColumn(JANNOVAR_SYMBOL);
        Matcher geneMatcher = geneSymbolPattern.matcher(geneString);
        if (geneMatcher.find()) {
            this.geneSymbol = geneMatcher.group(1);
        }
    }

    private void extractCoverage() throws FieldNotFoundException {
        String dp4Text = this.extractFromInfoColumn(DP4);
        String adText = this.extractFromFormatColumn(AD);
        String aoText = this.extractFromFormatColumn(AO);
        String dpText = this.extractFromFormatColumn(DP);
        if (dp4Text != null) {
            String[] delimited = dp4Text.split(",");
            this.referenceDepth = Integer.parseInt(delimited[0]) + Integer.parseInt(delimited[1]);
            this.alternateDepth = Integer.parseInt(delimited[2]) + Integer.parseInt(delimited[3]);
        } else if (adText != null && adText != VCF_MISSING_VALUE) {
            String[] adCoverageDelimited = adText.split(",");
            this.referenceDepth = Integer.parseInt(adCoverageDelimited[0]);
            this.alternateDepth = Integer.parseInt(adCoverageDelimited[1]);
        } else if (aoText != null && dpText != null && aoText != VCF_MISSING_VALUE && dpText != VCF_MISSING_VALUE) {
            int totalCount = Integer.parseInt(dpText);
            String[] aoCoverageDelimited = aoText.split(",");
            System.err.println("Fix covereage BUG here: " + this.getClass().getSimpleName());
            int[] aoCoverageInt = new int[aoCoverageDelimited.length];
            for (int i = 0; i != aoCoverageInt.length; ++i) {
                aoCoverageInt[i] = Integer.parseInt(aoCoverageDelimited[i]);
            }
            Arrays.sort(aoCoverageInt);
            this.alternateDepth = aoCoverageInt[0];
            this.referenceDepth = totalCount - this.alternateDepth;
        }
    }

    private class FieldNotFoundException
    extends Exception {
        public FieldNotFoundException(String message) {
            super(message);
        }
    }
}

