/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public abstract class Query<ThisType extends Query<ThisType>>
extends SqlObject
implements Verifiable<ThisType>,
Serializable {
    protected Query() {
    }

    @Override
    public final ThisType validate() throws ValidationException {
        this.doValidate();
        return this.getThisType();
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        this.validateTables(vContext);
    }

    protected void validateTables(ValidationContext vContext) throws ValidationException {
        Collection<Table> allTables = vContext.getTables();
        if (vContext.getParent() != null) {
            allTables = new HashSet<Table>(allTables);
            ValidationContext tmpVContext = vContext;
            while ((tmpVContext = tmpVContext.getParent()) != null) {
                allTables.addAll(tmpVContext.getTables());
            }
        }
        if (!allTables.containsAll(vContext.getColumnTables())) {
            throw new ValidationException("Columns used for unreferenced tables");
        }
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        vContext.addVerifiable(this);
    }

    public final void appendTo(AppendableExt app) throws IOException {
        SqlContext newContext = SqlContext.pushContext(app);
        newContext.setQuery(this);
        this.appendTo(app, newContext);
        SqlContext.popContext(app, newContext);
    }

    protected final ThisType getThisType() {
        return (ThisType)this;
    }

    protected abstract void appendTo(AppendableExt var1, SqlContext var2) throws IOException;
}

