/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class CreateViewQuery
extends BaseCreateQuery<CreateViewQuery> {
    private SelectQuery _selectQuery;
    private boolean _withCheckOption;

    public CreateViewQuery(Table table) {
        this((Object)table);
    }

    public CreateViewQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.VIEW, this._object);
    }

    @Override
    public CreateViewQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public CreateViewQuery setSelectQuery(SelectQuery selectQuery) {
        this._selectQuery = selectQuery;
        return this;
    }

    public CreateViewQuery setWithCheckOption(boolean withCheckOption) {
        this._withCheckOption = withCheckOption;
        return this;
    }

    @Override
    public final CreateViewQuery setTableSpace(String tableSpace) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        if (this._selectQuery != null && !vContext.isLocalOnly()) {
            this._selectQuery.collectSchemaObjects(new ValidationContext(vContext));
        }
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._selectQuery == null) {
            throw new ValidationException("missing select query");
        }
        SqlObjectList<SqlObject> selectColumns = this._selectQuery.getColumns();
        if (!this._columns.isEmpty() && this._columns.size() != selectColumns.size() && !this._selectQuery.hasAllColumns()) {
            throw new ValidationException("mismatched columns and select columns for view");
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append((CharSequence)"CREATE VIEW ").append((Appendee)this._object);
        if (!this._columns.isEmpty()) {
            app.append((CharSequence)" (").append((Appendee)this._columns).append((CharSequence)")");
        }
        app.append((CharSequence)" AS ").append((Appendee)this._selectQuery);
        if (this._withCheckOption) {
            app.append((CharSequence)" WITH CHECK OPTION");
        }
    }
}

