/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

public class GeneResult
implements Comparable<GeneResult> {
    private int nodeId;
    private double totalScore;
    private int scoreCount;
    private double totalPercentile;
    private int percentileCount;

    public GeneResult(int nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public int compareTo(GeneResult qr) {
        double diff = this.getAveragePercentile() - qr.getAveragePercentile();
        if (diff == 0.0) {
            return (int)diff;
        }
        return diff > 0.0 ? 1 : -1;
    }

    public int getNodeID() {
        return this.nodeId;
    }

    public double getAverageScore() {
        return this.totalScore / (double)this.scoreCount;
    }

    public double getAveragePercentile() {
        return this.totalPercentile / (double)this.percentileCount;
    }

    public void addScore(double score) {
        this.totalScore += score;
        ++this.scoreCount;
    }

    public void addPercentile(double percentile) {
        this.totalPercentile += percentile;
        ++this.percentileCount;
    }
}

