/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.validation.EvaluationMeasure;

public class AucRoc
extends EvaluationMeasure {
    public AucRoc(String name) {
        super(name);
    }

    @Override
    public double computeResult(boolean[] classes, double[] scores) {
        double[] rank = (double[])scores.clone();
        MatrixUtils.tiedRank(rank);
        double sumPosRanks = 0.0;
        int numPos = 0;
        int numNeg = 0;
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i]) {
                sumPosRanks += rank[i];
                ++numPos;
                continue;
            }
            ++numNeg;
        }
        if (numPos == 0 || numNeg == 0) {
            return 0.5;
        }
        double area = sumPosRanks - (double)(numPos * (numPos + 1) / 2);
        return area / (double)(numPos * numNeg);
    }
}

