/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.utils;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import org.apache.log4j.Logger;
import org.genemania.engine.converter.Mapping;

public class FileUtils {
    private static Logger logger = Logger.getLogger(FileUtils.class);
    public static final char NULL_CHAR = '\u0000';

    public static Map<String, String> loadSynonyms(Reader source, char delim, int idFieldNum, int synonymFieldNum, boolean forceUpper) throws IOException {
        String[] nextLine;
        LinkedHashMap<String, String> synonyms = new LinkedHashMap<String, String>();
        CSVReader reader = new CSVReader(source, delim, '\u0000');
        while ((nextLine = reader.readNext()) != null) {
            String id = nextLine[idFieldNum].trim();
            String synonym = nextLine[synonymFieldNum].trim().toUpperCase();
            if (forceUpper) {
                synonym = synonym.toUpperCase();
            }
            if (synonyms.containsKey(synonym)) {
                String storedId = (String)synonyms.get(synonym);
                if (storedId.equalsIgnoreCase(id)) continue;
                logger.info((Object)("consistency error: the same identifier belongs to two distinct unique ids: " + synonym));
                continue;
            }
            synonyms.put(synonym, id);
        }
        logger.info((Object)("total number of identifiers loaded from mapping file: " + synonyms.size()));
        return synonyms;
    }

    public static Mapping<String, String> loadMapping(Reader source, char delim, int idFieldNum, int synonymFieldNum, boolean convertToUpperCase) throws IOException {
        String[] nextLine;
        Mapping<String, String> mapping = new Mapping<String, String>();
        CSVReader reader = new CSVReader(source, delim, '\u0000');
        while ((nextLine = reader.readNext()) != null) {
            String id = nextLine[idFieldNum].trim();
            String synonym = nextLine[synonymFieldNum].trim();
            if (convertToUpperCase) {
                synonym = synonym.toUpperCase();
            }
            mapping.addAlias(synonym, id);
        }
        logger.info((Object)("total number of identifiers loaded from mapping file: " + mapping.size()));
        return mapping;
    }

    public static int dump(PrintWriter writer, Matrix network, Mapping mapping, char delim, boolean outputUIDs, boolean stripUIDs) {
        int n = 0;
        for (MatrixEntry e : network) {
            String colName;
            String rowName;
            if (e.get() == 0.0 || e.row() >= e.column()) continue;
            if (outputUIDs) {
                rowName = mapping.getUniqueIdForIndex(e.row()).toString();
                colName = mapping.getUniqueIdForIndex(e.column()).toString();
                if (stripUIDs) {
                    rowName = rowName.split(":")[1];
                    colName = colName.split(":")[1];
                }
            } else {
                rowName = mapping.getPreferredAliasForIndex(e.row()).toString();
                colName = mapping.getPreferredAliasForIndex(e.column()).toString();
            }
            String line = rowName + "\t" + colName + "\t" + e.get();
            writer.println(line);
            ++n;
        }
        return n;
    }

    public static Vector<String[]> loadRecords(Reader source, char delim, char ignore) throws IOException {
        String[] nextLine;
        Vector<String[]> queries = new Vector<String[]>();
        CSVReader reader = new CSVReader(source, delim);
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine[0].startsWith("#")) continue;
            queries.add(nextLine);
        }
        logger.info((Object)String.format("total %d records", queries.size()));
        return queries;
    }

    public static Vector<String[]> loadRecords(Reader source, char delim, char ignore, int upperLimit, int lowerLimit) throws IOException {
        String[] nextLine;
        Vector<String[]> queries = new Vector<String[]>();
        CSVReader reader = new CSVReader(source, delim);
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine[0].startsWith("#")) continue;
            queries.add(nextLine);
        }
        logger.info((Object)String.format("total %d records", queries.size()));
        return queries;
    }

    public static Map<String, List<String[]>> loadRecordsByOrganism(Reader source, char delim, char ignore) throws IOException {
        String[] nextLine;
        HashMap<String, List<String[]>> queries = new HashMap<String, List<String[]>>();
        CSVReader reader = new CSVReader(source, delim);
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine[0].startsWith("#") || nextLine.length < 2) continue;
            String[] query = new String[nextLine.length - 1];
            for (int i = 1; i < nextLine.length; ++i) {
                query[i - 1] = nextLine[i];
            }
            if (!queries.containsKey(nextLine[0])) {
                queries.put(nextLine[0], new ArrayList());
            }
            ((List)queries.get(nextLine[0])).add(query);
            System.out.println("Adding query " + nextLine[1] + " to " + nextLine[0]);
        }
        return queries;
    }
}

