/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.NodeCursor;

public class PreferredNames {
    Map<Long, String> preferredNames;

    public PreferredNames(long organismId, DataConnector dataConnector, String ... preferredSources) throws Exception {
        this.init(organismId, dataConnector, preferredSources);
    }

    void init(long organismId, DataConnector dataConnector, String[] preferredSources) throws Exception {
        this.preferredNames = new HashMap<Long, String>();
        NodeCursor cursor = dataConnector.getOrganismMediator().createNodeCursor(organismId);
        while (cursor.next()) {
            long id = cursor.getId();
            Node node = dataConnector.getNodeMediator().getNode(id, organismId);
            Collection genes = node.getGenes();
            this.preferredNames.put(id, this.getPreferred(genes, preferredSources));
        }
    }

    String getPreferred(Collection<Gene> genes, String[] preferredSources) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Gene gene : genes) {
            map.put(gene.getNamingSource().getName(), gene.getSymbol());
        }
        for (String source : preferredSources) {
            String name = (String)map.get(source);
            if (name == null) continue;
            return name;
        }
        throw new ApplicationException("could not find a symbol for gene from preferred sources, known symbols for this gene: " + map);
    }

    public String getName(long id) {
        String name = this.preferredNames.get(id);
        return name;
    }
}

