/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import org.apache.log4j.Logger;
import org.genemania.domain.Ontology;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;

public class OntologiesSummarizer
implements Summarizer {
    private static Logger logger = Logger.getLogger(OntologiesSummarizer.class);
    Organism organism;
    DataConnector dataConnector;

    public OntologiesSummarizer(Organism organism, DataConnector dataConnector) {
        this.organism = organism;
        this.dataConnector = dataConnector;
    }

    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        logger.info((Object)String.format("summarizing ontologies for organism %d - %s", this.organism.getId(), this.organism.getName()));
        Ontology ontology = this.organism.getOntology();
        GoAnnotations annos = this.dataConnector.getCache().getGoAnnotations(this.organism.getId(), "" + ontology.getId());
        GoIds goIds = this.dataConnector.getCache().getGoIds(this.organism.getId(), "" + ontology.getId());
        NodeIds nodeIds = this.dataConnector.getCache().getNodeIds(this.organism.getId());
        Matrix data = annos.getData();
        int numGenes = data.numRows();
        int numCategories = data.numCols();
        Vector annotationsPerGene = data.rowSums();
        Vector annotationsPerCategory = data.columnSums();
        this.reportAnnotationsPerGene(reporterFactory, nodeIds, annotationsPerGene);
        this.reportAnnotationsPerCategory(reporterFactory, goIds, annotationsPerCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAnnotationsPerGene(ReporterFactory reporterFactory, NodeIds nodeIds, Vector annotationsPerGene) throws Exception {
        Reporter reporter = reporterFactory.getReporter("gene_annos");
        reporter.init("Node ID", "Annotations");
        try {
            for (int i = 0; i < annotationsPerGene.getSize(); ++i) {
                long nodeId = nodeIds.getIdForIndex(i);
                long count = Math.round(annotationsPerGene.get(i));
                if (count == 0L) continue;
                reporter.write("" + nodeId, "" + count);
            }
        }
        finally {
            reporter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAnnotationsPerCategory(ReporterFactory reporterFactory, GoIds goIds, Vector annotationsPerCategory) throws Exception {
        Reporter reporter = reporterFactory.getReporter("category_annos");
        reporter.init("Category ID", "Annotations");
        try {
            for (int i = 0; i < annotationsPerCategory.getSize(); ++i) {
                String categoryId = goIds.getIdForIndex(i);
                long count = Math.round(annotationsPerCategory.get(i));
                if (count == 0L) continue;
                reporter.write(categoryId, "" + count);
            }
        }
        finally {
            reporter.close();
        }
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
    }
}

