/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.mtj;

import java.io.IOException;
import java.util.Iterator;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.sparse.CG;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixAccumulator;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.SimpleMatrixAccumulator;
import org.genemania.engine.matricks.mtj.DenseDoubleVector;

public class SparseDoubleMatrix
implements Matrix {
    FlexCompColMatrix m;

    public SparseDoubleMatrix(int rows, int cols) {
        this.m = new FlexCompColMatrix(rows, cols);
    }

    public SparseDoubleMatrix(FlexCompColMatrix m) {
        this.m = m;
    }

    @Override
    public double elementSum() {
        return MatrixUtils.sum((no.uib.cipr.matrix.Matrix)this.m);
    }

    @Override
    public double elementMultiplySum(Matrix B) {
        if (B instanceof SparseDoubleMatrix) {
            SparseDoubleMatrix BB = (SparseDoubleMatrix)B;
            return this.elementMultiplySum(BB);
        }
        throw new RuntimeException("not implemented");
    }

    public double elementMultiplySum(SparseDoubleMatrix B) {
        return MatrixUtils.elementMultiplySum((no.uib.cipr.matrix.Matrix)this.m, (no.uib.cipr.matrix.Matrix)B.m);
    }

    @Override
    public void add(Matrix B) {
        throw new RuntimeException("not implemented for given type: " + B.getClass().getName());
    }

    @Override
    public void add(double a, Matrix B) {
        if (!(B instanceof SparseDoubleMatrix)) {
            throw new RuntimeException("not implemented for given type: " + B.getClass().getName());
        }
        SparseDoubleMatrix BB = (SparseDoubleMatrix)B;
        this.add(a, BB);
    }

    public void add(SparseDoubleMatrix B) {
        this.m.add((no.uib.cipr.matrix.Matrix)B.m);
    }

    public void add(double a, SparseDoubleMatrix B) {
        this.m.add(a, (no.uib.cipr.matrix.Matrix)B.m);
    }

    @Override
    public MatrixCursor cursor() {
        return new SparseDoubleMatrixCursor();
    }

    @Override
    public void setAll(double a) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void scale(double a) {
        this.m.scale(a);
    }

    @Override
    public void set(int i, int j, double val) {
        this.m.set(i, j, val);
    }

    @Override
    public double get(int i, int j) {
        return this.m.get(i, j);
    }

    @Override
    public int numCols() {
        return this.m.numColumns();
    }

    @Override
    public int numRows() {
        return this.m.numRows();
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        if (!(x instanceof DenseDoubleVector)) {
            throw new MatricksException("unexpected implementation: " + x.getClass().getName());
        }
        if (!(y instanceof DenseDoubleVector)) {
            throw new MatricksException("unexpected implementation: " + y.getClass().getName());
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        CG cg = new CG((no.uib.cipr.matrix.Vector)new DenseVector(x.getSize()));
        try {
            cg.solve((no.uib.cipr.matrix.Matrix)this.m, xx.v, yy.v);
        }
        catch (IterativeSolverNotConvergedException e) {
            throw new MatricksException("failed to converge");
        }
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        return new DenseDoubleVector(MatrixUtils.rowSums((no.uib.cipr.matrix.Matrix)this.m));
    }

    @Override
    public Vector columnSums() throws MatricksException {
        return new DenseDoubleVector(MatrixUtils.columnSums((no.uib.cipr.matrix.Matrix)this.m));
    }

    @Override
    public void setToMaxTranspose() {
        for (MatrixEntry e : this.m) {
            double v;
            double u = e.get();
            if (u > (v = this.m.get(e.column(), e.row()))) {
                this.m.set(e.column(), e.row(), u);
                continue;
            }
            if (!(v > u)) continue;
            e.set(v);
        }
    }

    @Override
    public void multAdd(double a, Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new RuntimeException("not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.multAdd(a, xx, yy);
    }

    public void multAdd(double a, DenseDoubleVector x, DenseDoubleVector y) {
        this.m.multAdd(a, x.v, y.v);
    }

    @Override
    public void mult(Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new RuntimeException("not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.mult(xx, yy);
    }

    public void mult(DenseDoubleVector x, DenseDoubleVector y) {
        this.m.mult(x.v, y.v);
    }

    public void dotDivOuterProd(Vector x) {
        MatrixCursor mCursor = this.cursor();
        while (mCursor.next()) {
            mCursor.set(mCursor.val() / (x.get(mCursor.row()) * x.get(mCursor.col())));
        }
    }

    public static FlexCompColMatrix sparseFlexCopy(no.uib.cipr.matrix.Matrix m) {
        FlexCompColMatrix f = new FlexCompColMatrix(m.numRows(), m.numColumns());
        for (MatrixEntry e : m) {
            if (e.get() == 0.0) continue;
            f.set(e.row(), e.column(), e.get());
        }
        return f;
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        no.uib.cipr.matrix.Matrix subMatrix = Matrices.getSubMatrix((no.uib.cipr.matrix.Matrix)this.m, (int[])rows, (int[])cols);
        FlexCompColMatrix subMatrixCopy = SparseDoubleMatrix.sparseFlexCopy(subMatrix);
        return new SparseDoubleMatrix(subMatrixCopy);
    }

    @Override
    public void rowSums(double[] result) {
        MatrixUtils.rowSums((no.uib.cipr.matrix.Matrix)this.m, result);
    }

    @Override
    public void columnSums(double[] result) {
        MatrixUtils.columnSums((no.uib.cipr.matrix.Matrix)this.m, result);
    }

    @Override
    public void add(int i, int j, double alpha) {
        this.m.add(i, j, alpha);
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        DenseVector xx = new DenseVector(x, false);
        DenseVector yy = new DenseVector(y, false);
        this.m.multAdd((no.uib.cipr.matrix.Vector)xx, (no.uib.cipr.matrix.Vector)yy);
    }

    @Override
    public void compact() {
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void mmwrite(String filename) throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Matrix mmread(String filename) throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public MatrixAccumulator accumulator() {
        return new SimpleMatrixAccumulator(this);
    }

    private class SparseDoubleMatrixCursor
    implements MatrixCursor {
        Iterator<MatrixEntry> iter;
        MatrixEntry e;

        private SparseDoubleMatrixCursor() {
            this.iter = SparseDoubleMatrix.this.m.iterator();
        }

        @Override
        public boolean next() {
            if (this.iter.hasNext()) {
                this.e = this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public int row() {
            return this.e.row();
        }

        @Override
        public int col() {
            return this.e.column();
        }

        @Override
        public double val() {
            return this.e.get();
        }

        @Override
        public void set(double val) {
            this.e.set(val);
        }
    }
}

