/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.util.Arrays;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.FlexFloatArray;
import org.genemania.engine.matricks.custom.FlexFloatColMatrix;
import org.genemania.engine.matricks.custom.FlexSymFloatMatrix;

public class Outer1View
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = -7955896586715295648L;
    int size;
    FlexFloatArray newData;
    double scale;
    boolean zeroDiag;

    public static Outer1View fromColumn(Matrix backingMatrix, int backingColumn, int[] indices, double scale, boolean zeroDiag) {
        if (backingMatrix instanceof FlexFloatColMatrix) {
            FlexFloatColMatrix m = (FlexFloatColMatrix)backingMatrix;
            FlexFloatArray backing = m.getColumn(backingColumn);
            return new Outer1View(backing, indices, scale, zeroDiag);
        }
        throw new RuntimeException("matrix type not supported: " + backingMatrix.getClass().getName());
    }

    public static Outer1View fromColumn(Matrix backingMatrix, int backingColumn, double scale, boolean zeroDiag) {
        if (backingMatrix instanceof FlexFloatColMatrix) {
            FlexFloatColMatrix m = (FlexFloatColMatrix)backingMatrix;
            FlexFloatArray backing = m.getColumn(backingColumn);
            return new Outer1View(backing, scale, zeroDiag);
        }
        throw new RuntimeException("matrix type not supported: " + backingMatrix.getClass().getName());
    }

    public Outer1View(FlexFloatArray backing, int[] indices, double scale, boolean zeroDiag) {
        this.size = indices.length;
        this.scale = scale;
        this.zeroDiag = zeroDiag;
        int[] common = Outer1View.getCommonIndices(indices, indices.length, backing.indices, backing.used);
        int[] positions = Outer1View.getPositionsOfCommonIndicesOfAInB(indices, indices.length, backing.indices, backing.used);
        this.newData = new FlexFloatArray();
        for (int index = 0; index < common.length; ++index) {
            float val = (float)backing.get(common[index]);
            this.newData.set(positions[index], val);
        }
    }

    public Outer1View(FlexFloatArray backing, double scale, boolean zeroDiag) {
        this.size = backing.used;
        this.scale = scale;
        this.zeroDiag = zeroDiag;
        this.newData = backing;
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        if (this.zeroDiag && row == col) {
            return 0.0;
        }
        return this.scale * this.newData.get(row) * this.newData.get(col);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new RuntimeException("read-only");
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        if (m instanceof FlexSymFloatMatrix) {
            return m.elementMultiplySum(this);
        }
        if (m instanceof Outer1View) {
            return this.elementMultiplySum((Outer1View)m);
        }
        return super.elementMultiplySum(m);
    }

    public double elementMultiplySum(Outer1View m) throws MatricksException {
        double dot = this.newData.dot(m.newData);
        double sum = dot * dot;
        if (this.zeroDiag || m.zeroDiag) {
            sum -= this.newData.squaredDot(m.newData);
        }
        return sum * this.scale * m.scale;
    }

    @Override
    public double elementSum() throws MatricksException {
        double sum = this.newData.elementSum();
        sum *= sum;
        if (this.zeroDiag) {
            sum -= this.newData.elementSquaredSum();
        }
        return sum * this.scale;
    }

    @Override
    public MatrixCursor cursor() {
        return new MatrixCursor(){
            int i = -1;
            int j = 0;
            final int k;
            {
                this.k = Outer1View.this.newData.used - 1;
            }

            @Override
            public boolean next() {
                if (this.i < this.k) {
                    ++this.i;
                    return true;
                }
                if (this.j < this.k) {
                    this.i = 0;
                    ++this.j;
                    return true;
                }
                return false;
            }

            @Override
            public int row() {
                return Outer1View.this.newData.indices[this.i];
            }

            @Override
            public int col() {
                return Outer1View.this.newData.indices[this.j];
            }

            @Override
            public double val() {
                if (Outer1View.this.zeroDiag && this.i == this.j) {
                    return 0.0;
                }
                return Outer1View.this.scale * (double)Outer1View.this.newData.data[this.i] * (double)Outer1View.this.newData.data[this.j];
            }

            @Override
            public void set(double val) {
                throw new RuntimeException("read-only");
            }
        };
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        Arrays.fill(y, 0.0);
        for (int i = 0; i < this.newData.used; ++i) {
            int row = this.newData.indices[i];
            for (int j = 0; j < this.newData.used; ++j) {
                int col = this.newData.indices[j];
                if (this.zeroDiag && i == j) continue;
                int n = row;
                y[n] = y[n] + this.scale * x[col];
            }
        }
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new RuntimeException("not implemented");
    }
}

