/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.DenseDoubleVector;
import org.genemania.engine.matricks.custom.FlexDoubleArray;
import org.genemania.engine.matricks.custom.FlexDoubleMatrix;

public class FlexSymDoubleMatrix
extends AbstractMatrix
implements SymMatrix {
    int size;
    double[] diag;
    FlexDoubleArray[] data;
    static int maxIter = 100000;
    static double rtol = 1.0E-5;
    static double atol = 1.0E-50;
    static double dtol = 100000.0;

    public FlexSymDoubleMatrix(int size) {
        this.size = size;
        this.alloc();
    }

    private void alloc() {
        this.data = new FlexDoubleArray[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = new FlexDoubleArray(i);
        }
        this.diag = new double[this.size];
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        this.checkIdx(row, col);
        if (row > col) {
            return this.data[row].get(col);
        }
        if (row < col) {
            return this.data[col].get(row);
        }
        return this.diag[row];
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        this.checkIdx(row, col);
        if (row > col) {
            this.data[row].set(col, val);
        } else if (row < col) {
            this.data[col].set(row, val);
        } else {
            this.diag[row] = val;
        }
    }

    private void checkIdx(int row, int col) {
        if (row < 0 || row >= this.size) {
            throw new IndexOutOfBoundsException(String.format("invalid row index: %d", row));
        }
        if (col < 0 || col >= this.size) {
            throw new IndexOutOfBoundsException(String.format("invalid column index: %d", col));
        }
    }

    @Override
    public void scale(double a) throws MatricksException {
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.scale(a);
            this.diag[row] = a * this.diag[row];
        }
    }

    @Override
    public void setAll(double a) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        return new FlexSymDoubleMatrixCursor();
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        if (!(B instanceof FlexSymDoubleMatrix)) {
            throw new RuntimeException("not implemented for: " + B.getClass().getName());
        }
        FlexSymDoubleMatrix BB = (FlexSymDoubleMatrix)B;
        this.add(a, BB);
    }

    public void add(double alpha, FlexSymDoubleMatrix B) throws MatricksException {
        int row;
        for (row = 0; row < B.size; ++row) {
            this.data[row].add(alpha, B.data[row]);
        }
        for (row = 0; row < B.size; ++row) {
            this.diag[row] = this.diag[row] + alpha * B.diag[row];
        }
    }

    @Override
    public double elementSum() {
        double sum = 0.0;
        for (int row = 0; row < this.size; ++row) {
            double rowSum = this.data[row].elementSum();
            sum += 2.0 * rowSum;
            sum += this.diag[row];
        }
        return sum;
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        if (m instanceof FlexSymDoubleMatrix) {
            return this.elementMultiplySum((FlexSymDoubleMatrix)m);
        }
        throw new RuntimeException("not implemented");
    }

    public double elementMultiplySum(FlexSymDoubleMatrix m) throws MatricksException {
        double sum = 0.0;
        for (int row = 0; row < this.size; ++row) {
            double rowDot = this.data[row].dot(m.data[row]);
            sum += 2.0 * rowDot;
            sum += this.diag[row] * m.diag[row];
        }
        return sum;
    }

    @Override
    public void CG(Vector b, Vector x) throws MatricksException {
        double initR;
        int n = x.getSize();
        if (n != b.getSize() || n != this.size || n != this.size) {
            throw new MatricksException("inconsistent data sizes");
        }
        DenseDoubleVector p = new DenseDoubleVector(n);
        DenseDoubleVector z = new DenseDoubleVector(n);
        DenseDoubleVector q = new DenseDoubleVector(n);
        DenseDoubleVector r = new DenseDoubleVector(n);
        double alpha = 0.0;
        double beta = 0.0;
        double rho = 0.0;
        double rho_1 = 0.0;
        r.setEqual(b);
        this.multAdd(-1.0, x, (Vector)r);
        double currentR = initR = Math.sqrt(r.dot((Vector)r));
        int iter = 0;
        while (!this.converged(iter, initR, currentR, x)) {
            z.setEqual((Vector)r);
            rho = r.dot((Vector)z);
            if (iter == 0) {
                p.setEqual((Vector)z);
            } else {
                beta = rho / rho_1;
                p.scale(beta);
                p.add(z);
            }
            this.mult((Vector)p, (Vector)q);
            alpha = rho / p.dot((Vector)q);
            x.add(alpha, p);
            r.add(-alpha, q);
            rho_1 = rho;
            currentR = Math.sqrt(r.dot((Vector)r));
            ++iter;
        }
    }

    public boolean converged(int iter, double initR, double currentR, Vector x) throws MatricksException {
        if (currentR < Math.max(rtol * initR, atol)) {
            return true;
        }
        if (Double.isNaN(currentR)) {
            throw new MatricksException("diverged");
        }
        if (currentR > dtol * initR) {
            throw new MatricksException("diverged");
        }
        if (iter >= maxIter) {
            throw new MatricksException("max iterations reached");
        }
        return false;
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        double[] y = new double[this.size];
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.partialSum(y, row);
        }
        this.addDiag(y);
        return new DenseDoubleVector(y);
    }

    @Override
    public Vector columnSums() throws MatricksException {
        return this.rowSums();
    }

    @Override
    public void rowSums(double[] result) {
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.partialSum(result, row);
        }
        this.addDiag(result);
    }

    @Override
    public void columnSums(double[] result) {
        this.rowSums(result);
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new RuntimeException("not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.multAdd(alpha, xx, yy);
    }

    public void multAdd(double alpha, DenseDoubleVector x, DenseDoubleVector y) {
        this.multAdd(alpha, x.data, y.data);
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.partialMult(alpha, x, y, row);
        }
        this.addDiag(alpha, x, y);
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.partialMult(x, y, row);
        }
        this.addDiag(x, y);
    }

    protected void addDiag(double alpha, double[] x, double[] y) {
        for (int row = 0; row < this.size; ++row) {
            y[row] = y[row] + alpha * x[row] * this.diag[row];
        }
    }

    protected void addDiag(double[] y) {
        for (int row = 0; row < this.size; ++row) {
            y[row] = y[row] + this.diag[row];
        }
    }

    protected void addDiag(double[] x, double[] y) {
        for (int row = 0; row < this.size; ++row) {
            y[row] = y[row] + x[row] * this.diag[row];
        }
    }

    @Override
    public void mult(Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new RuntimeException("not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.mult(xx, yy);
    }

    public void mult(DenseDoubleVector x, DenseDoubleVector y) {
        this.mult(x.data, y.data);
    }

    @Override
    public void mult(double[] x, double[] y) {
        FlexSymDoubleMatrix.clear(y);
        for (int row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.partialMult(x, y, row);
        }
        this.addDiag(x, y);
    }

    protected static void clear(double[] y) {
        for (int i = 0; i < y.length; ++i) {
            y[i] = 0.0;
        }
    }

    public void dotMultOuterProd(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    public void dotDivOuterProd(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    public void dotMultOuterProd(double[] x) {
        throw new RuntimeException("not implemented");
    }

    public void dotDivOuterProd(double[] x) {
        int row;
        for (row = 0; row < this.size; ++row) {
            FlexDoubleArray d = this.data[row];
            d.dotDiv(x[row], x);
        }
        for (row = 0; row < this.size; ++row) {
            this.diag[row] = this.diag[row] / (x[row] * x[row]);
        }
    }

    @Override
    public void dotDivOuterProd(Vector x) {
        if (x instanceof DenseDoubleVector) {
            DenseDoubleVector xx = (DenseDoubleVector)x;
            this.dotDivOuterProd(xx);
        }
    }

    public void dotDivOuterProd(DenseDoubleVector x) {
        this.dotDivOuterProd(x.data);
    }

    @Override
    public void addOuterProd(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double prod = x[i] * x[j];
                FlexDoubleArray d = this.data[i];
                if (prod == 0.0) continue;
                d.add(j, prod);
            }
        }
        for (int row = 0; row < this.size; ++row) {
            this.diag[row] = this.diag[row] + x[row] * x[row];
        }
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            FlexDoubleArray d = this.data[i];
            double s = d.dot(x);
            sum += s * x[i];
        }
        sum = 2.0 * sum;
        for (int row = 0; row < this.size; ++row) {
            sum += this.diag[row] * (x[row] * x[row]);
        }
        return sum;
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        FlexSymDoubleMatrix subMatrix = new FlexSymDoubleMatrix(rowcols.length);
        for (int i = 0; i < rowcols.length; ++i) {
            int idx = rowcols[i];
            for (int j = 0; j < rowcols.length; ++j) {
                double v;
                int jdx = rowcols[j];
                if (idx <= jdx || (v = this.get(idx, jdx)) == 0.0) continue;
                subMatrix.set(i, j, v);
            }
            double v = this.get(idx, idx);
            if (v == 0.0) continue;
            subMatrix.set(i, i, v);
        }
        return subMatrix;
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        FlexDoubleMatrix subMatrix = new FlexDoubleMatrix(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            int idx = rows[i];
            for (int j = 0; j < cols.length; ++j) {
                int jdx = cols[j];
                double v = this.get(idx, jdx);
                if (v == 0.0) continue;
                subMatrix.set(i, j, v);
            }
        }
        return subMatrix;
    }

    @Override
    public void setDiag(double alpha) {
        for (int i = 0; i < this.size; ++i) {
            this.diag[i] = alpha;
        }
    }

    @Override
    public void add(int i, int j, double alpha) {
        if (i != j) {
            this.data[i].add(j, alpha);
        } else {
            this.diag[i] = this.diag[i] + alpha;
        }
    }

    @Override
    public void compact() {
        for (int row = 0; row < this.size; ++row) {
            this.data[row].compact();
        }
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    private class FlexSymDoubleMatrixCursor
    implements MatrixCursor {
        boolean symToggle = true;
        boolean onDiag = false;
        int row = 0;
        int index = -1;
        int col = -1;
        double val;

        private FlexSymDoubleMatrixCursor() {
        }

        @Override
        public boolean next() {
            if (this.onDiag) {
                ++this.row;
                if (this.row >= FlexSymDoubleMatrix.this.size) {
                    return false;
                }
                this.col = this.row;
                this.val = FlexSymDoubleMatrix.this.diag[this.row];
                return true;
            }
            if (!this.symToggle) {
                this.symToggle = true;
            } else {
                ++this.index;
                boolean ok = true;
                if (this.index >= FlexSymDoubleMatrix.this.data[this.row].data.length) {
                    ok = this.advanceOffDiagRow();
                }
                if (!ok) {
                    this.onDiag = true;
                    this.row = 0;
                    this.col = 0;
                    this.val = FlexSymDoubleMatrix.this.diag[this.row];
                } else {
                    this.val = FlexSymDoubleMatrix.this.data[this.row].data[this.index];
                    this.col = FlexSymDoubleMatrix.this.data[this.row].indices[this.index];
                }
                this.symToggle = false;
            }
            return true;
        }

        private boolean advanceOffDiagRow() {
            ++this.row;
            while (this.row < FlexSymDoubleMatrix.this.size) {
                if (FlexSymDoubleMatrix.this.data[this.row].data.length > 0) {
                    this.index = 0;
                    return true;
                }
                ++this.row;
            }
            return false;
        }

        @Override
        public int row() {
            if (this.symToggle) {
                return this.col;
            }
            return this.row;
        }

        @Override
        public int col() {
            if (this.symToggle) {
                return this.row;
            }
            return this.col;
        }

        @Override
        public double val() {
            return this.val;
        }

        @Override
        public void set(double val) {
            throw new RuntimeException("not implemented");
        }
    }
}

