/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.io.Serializable;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Utils;
import org.genemania.engine.matricks.custom.DenseDoubleVector;

public class FlexFloatArray
implements Serializable {
    private static final long serialVersionUID = 3079385376377680800L;
    public static final int FIRST_ALLOC_SIZE = 8;
    int size;
    int used;
    float[] data;
    int[] indices;

    public FlexFloatArray() {
        this(Integer.MAX_VALUE, 8);
    }

    public FlexFloatArray(int size) {
        this(size, 8);
    }

    public FlexFloatArray(int size, int nz) {
        this.size = size;
        this.alloc(nz);
    }

    private void alloc(int nz) {
        this.data = new float[nz];
        this.indices = new int[nz];
    }

    public double get(int index) {
        int pos = Utils.binarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            return this.data[pos];
        }
        return 0.0;
    }

    public void set(int index, float val) throws MatricksException {
        int pos = Utils.myBinarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            this.data[pos] = val;
        } else {
            this.insert(-pos - 1, index, val);
        }
    }

    private void insert(int pos, int index, float val) throws MatricksException {
        if (this.used < this.data.length) {
            System.arraycopy(this.indices, pos, this.indices, pos + 1, this.used - pos);
            System.arraycopy(this.data, pos, this.data, pos + 1, this.used - pos);
            this.indices[pos] = index;
            this.data[pos] = val;
            ++this.used;
        } else {
            int newsize = this.getNewSize();
            float[] newData = new float[newsize];
            int[] newIndices = new int[newsize];
            System.arraycopy(this.indices, 0, newIndices, 0, pos);
            System.arraycopy(this.data, 0, newData, 0, pos);
            System.arraycopy(this.indices, pos, newIndices, pos + 1, this.used - pos);
            System.arraycopy(this.data, pos, newData, pos + 1, this.used - pos);
            newIndices[pos] = index;
            newData[pos] = val;
            ++this.used;
            this.indices = newIndices;
            this.data = newData;
        }
    }

    private int getNewSize() throws MatricksException {
        int newsize;
        if (this.data == null || this.data.length == 0) {
            newsize = 8;
        } else {
            if (this.data.length >= this.size) {
                throw new MatricksException(String.format("already at max size of %s", this.size));
            }
            newsize = this.data.length * 2;
            if (newsize > this.size) {
                newsize = this.size;
            }
        }
        return newsize;
    }

    private static int getNewSize(int size, int maxsize) throws MatricksException {
        int newsize;
        if (size == 0) {
            newsize = 8;
        } else {
            double exponent = Math.ceil(Math.log(size) / Math.log(2.0));
            newsize = (int)Math.round(Math.pow(2.0, exponent));
            newsize = Math.min(newsize, maxsize);
        }
        return newsize;
    }

    public MatrixCursor cursor() {
        return new FlexFloatArrayCursor();
    }

    public double dot(DenseDoubleVector v) {
        return this.dot(v.data);
    }

    public double dot(double[] v) {
        double result = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            result += (x *= v[row]);
        }
        return result;
    }

    public double dot(float[] v) {
        double result = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            result += (x *= (double)v[row]);
        }
        return result;
    }

    public void add(double alpha, DenseDoubleVector v) {
        this.add(alpha, v.data);
    }

    public void add(double alpha, double[] v) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            v[row] = v[row] + alpha * x;
        }
    }

    public void add(double alpha, float[] v, int offset) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            v[offset + row] = (float)((double)v[offset + row] + alpha * (double)this.data[index]);
        }
    }

    public void add(double alpha, double[] v, int offset) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            v[offset + row] = v[offset + row] + alpha * (double)this.data[index];
        }
    }

    public void add(float[] v, int offset) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            v[offset + row] = v[offset + row] + this.data[index];
        }
    }

    public void add(double[] v, int offset) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            v[offset + row] = v[offset + row] + (double)this.data[index];
        }
    }

    protected void partialMult(double[] x, double[] y, int k) {
        double z = x[k];
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double w = this.data[index];
            s += w * x[row];
            int n = row;
            y[n] = y[n] + w * z;
        }
        int n = k;
        y[n] = y[n] + s;
    }

    protected void partialMult(double alpha, double[] x, double[] y, int k) {
        double z = x[k];
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double w = this.data[index];
            s += w * x[row];
            int n = row;
            y[n] = y[n] + alpha * w * z;
        }
        int n = k;
        y[n] = y[n] + alpha * s;
    }

    protected void partialSum(double[] y, int k) {
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            s += x;
            int n = row;
            y[n] = y[n] + x;
        }
        int n = k;
        y[n] = y[n] + s;
    }

    public void scale(double alpha) {
        for (int index = 0; index < this.used; ++index) {
            this.data[index] = (float)(alpha * (double)this.data[index]);
        }
    }

    public void dotMultAdd(double[] y, double alpha) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            int n = row;
            y[n] = y[n] + alpha * x;
        }
    }

    public void dotDiv(double alpha, double[] x) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            this.data[index] = (float)((double)this.data[index] / (alpha * x[row]));
        }
    }

    public void dotDiv(double[] x) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            this.data[index] = (float)((double)this.data[index] / x[row]);
        }
    }

    public void add(FlexFloatArray x) throws MatricksException {
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            float x_at_row = x.data[index];
            this.add(row, x_at_row);
        }
    }

    public void addTo(double[] x) throws MatricksException {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            x[row] = x[row] + (double)this.data[index];
        }
    }

    public void add(double alpha, FlexFloatArray x) throws MatricksException {
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            float x_at_row = x.data[index];
            this.add(row, (float)(alpha * (double)x_at_row));
        }
    }

    public void addWithWorkArrays(double alpha, FlexFloatArray x, int[] workIndices, float[] workData) throws MatricksException {
        if (x.used == 0) {
            return;
        }
        int i = 0;
        int ix = 0;
        int iwork = 0;
        int nextpos = Integer.MAX_VALUE;
        int nextxpos = Integer.MAX_VALUE;
        if (i < this.used) {
            nextpos = this.indices[i];
        }
        if (ix < x.used) {
            nextxpos = x.indices[ix];
        }
        while (i < this.used || ix < x.used) {
            if (nextpos < nextxpos) {
                workIndices[iwork] = nextpos;
                workData[iwork] = this.data[i];
                ++iwork;
                if (++i < this.used) {
                    nextpos = this.indices[i];
                    continue;
                }
                nextpos = Integer.MAX_VALUE;
                continue;
            }
            if (nextpos > nextxpos) {
                workIndices[iwork] = nextxpos;
                workData[iwork] = (float)(alpha * (double)x.data[ix]);
                ++iwork;
                if (++ix < x.used) {
                    nextxpos = x.indices[ix];
                    continue;
                }
                nextxpos = Integer.MAX_VALUE;
                continue;
            }
            workIndices[iwork] = nextpos;
            workData[iwork] = (float)((double)this.data[i] + alpha * (double)x.data[ix]);
            ++iwork;
            nextpos = ++i < this.used ? this.indices[i] : Integer.MAX_VALUE;
            if (++ix < x.used) {
                nextxpos = x.indices[ix];
                continue;
            }
            nextxpos = Integer.MAX_VALUE;
        }
        if (iwork <= this.data.length) {
            System.arraycopy(workIndices, 0, this.indices, 0, iwork);
            System.arraycopy(workData, 0, this.data, 0, iwork);
        } else {
            int newsize = FlexFloatArray.getNewSize(iwork, this.size);
            this.indices = new int[newsize];
            this.data = new float[newsize];
            System.arraycopy(workIndices, 0, this.indices, 0, iwork);
            System.arraycopy(workData, 0, this.data, 0, iwork);
        }
        this.used = iwork;
    }

    public void add(int index, float val) throws MatricksException {
        int pos = Utils.myBinarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            this.data[pos] = this.data[pos] + val;
        } else {
            this.insert(-pos - 1, index, val);
        }
    }

    public double elementSum() {
        double sum = 0.0;
        for (int index = 0; index < this.used; ++index) {
            sum += (double)this.data[index];
        }
        return sum;
    }

    public double elementSquaredSum() {
        double sum = 0.0;
        for (int index = 0; index < this.used; ++index) {
            double d = this.data[index];
            sum += d * d;
        }
        return sum;
    }

    public double dot(FlexFloatArray x) {
        double sum = 0.0;
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            double x_at_row = x.data[index];
            int pos = Utils.myBinarySearch(this.indices, row, 0, this.used);
            if (pos < 0) continue;
            sum += (double)this.data[pos] * x_at_row;
        }
        return sum;
    }

    public double squaredDot(FlexFloatArray x) {
        double sum = 0.0;
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            double x_at_row = x.data[index];
            int pos = Utils.myBinarySearch(this.indices, row, 0, this.used);
            if (pos < 0) continue;
            double d = this.data[pos];
            sum += d * d * x_at_row * x_at_row;
        }
        return sum;
    }

    public void compact() {
        if (this.data.length == this.used) {
            return;
        }
        float[] newData = new float[this.used];
        int[] newIndices = new int[this.used];
        System.arraycopy(this.data, 0, newData, 0, this.used);
        System.arraycopy(this.indices, 0, newIndices, 0, this.used);
        this.data = newData;
        this.indices = newIndices;
    }

    public FlexFloatArray copy() {
        FlexFloatArray newArray = new FlexFloatArray(this.used);
        System.arraycopy(this.data, 0, newArray.data, 0, this.used);
        System.arraycopy(this.indices, 0, newArray.indices, 0, this.used);
        return newArray;
    }

    public float[] toDense() {
        float[] denseData = new float[this.indices[this.used - 1] + 1];
        for (int i = 0; i < this.used; ++i) {
            denseData[this.indices[i]] = this.data[i];
        }
        return denseData;
    }

    private class FlexFloatArrayCursor
    implements MatrixCursor {
        private int index = -1;

        private FlexFloatArrayCursor() {
        }

        @Override
        public boolean next() {
            ++this.index;
            return this.index < FlexFloatArray.this.used;
        }

        @Override
        public int row() {
            return FlexFloatArray.this.indices[this.index];
        }

        @Override
        public int col() {
            return 0;
        }

        @Override
        public double val() {
            return FlexFloatArray.this.data[this.index];
        }

        @Override
        public void set(double val) {
            FlexFloatArray.this.data[this.index] = (float)val;
        }
    }
}

