/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.io.Serializable;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Utils;
import org.genemania.engine.matricks.custom.DenseDoubleVector;

public class FlexDoubleArray
implements Serializable {
    public static final int FIRST_ALLOC_SIZE = 8;
    int size;
    int used;
    double[] data;
    int[] indices;

    public FlexDoubleArray() {
        this(Integer.MAX_VALUE, 8);
    }

    public FlexDoubleArray(int size) {
        this(size, 8);
    }

    public FlexDoubleArray(int size, int nz) {
        this.size = size;
        this.alloc(nz);
    }

    public int getSize() {
        return this.size;
    }

    public int nnz() {
        return this.used;
    }

    private void alloc(int nz) {
        this.data = new double[nz];
        this.indices = new int[nz];
    }

    public double get(int index) {
        int pos = Utils.binarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            return this.data[pos];
        }
        return 0.0;
    }

    public void set(int index, double val) throws MatricksException {
        int pos = Utils.myBinarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            this.data[pos] = val;
        } else {
            this.insert(-pos - 1, index, val);
        }
    }

    private void insert(int pos, int index, double val) throws MatricksException {
        if (this.used < this.data.length) {
            System.arraycopy(this.indices, pos, this.indices, pos + 1, this.used - pos);
            System.arraycopy(this.data, pos, this.data, pos + 1, this.used - pos);
            this.indices[pos] = index;
            this.data[pos] = val;
            ++this.used;
        } else {
            int newsize = this.getNewSize();
            double[] newData = new double[newsize];
            int[] newIndices = new int[newsize];
            System.arraycopy(this.indices, 0, newIndices, 0, pos);
            System.arraycopy(this.data, 0, newData, 0, pos);
            System.arraycopy(this.indices, pos, newIndices, pos + 1, this.used - pos);
            System.arraycopy(this.data, pos, newData, pos + 1, this.used - pos);
            newIndices[pos] = index;
            newData[pos] = val;
            ++this.used;
            this.indices = newIndices;
            this.data = newData;
        }
    }

    private int getNewSize() throws MatricksException {
        int newsize;
        if (this.data == null || this.data.length == 0) {
            newsize = 8;
        } else {
            if (this.data.length == this.size) {
                throw new MatricksException(String.format("already at max size of %s", this.size));
            }
            newsize = this.data.length * 2;
            if (newsize > this.size) {
                newsize = this.size;
            }
        }
        return newsize;
    }

    public MatrixCursor cursor() {
        return new FlexDoubleArrayCursor();
    }

    public double dot(DenseDoubleVector v) {
        return this.dot(v.data);
    }

    public double dot(double[] v) {
        double result = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            result += (x *= v[row]);
        }
        return result;
    }

    public void add(double alpha, DenseDoubleVector v) {
        double[] d = v.data;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            d[row] = d[row] + alpha * x;
        }
    }

    protected void partialMult(double[] x, double[] y, int k) {
        double z = x[k];
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double w = this.data[index];
            s += w * x[row];
            int n = row;
            y[n] = y[n] + w * z;
        }
        int n = k;
        y[n] = y[n] + s;
    }

    protected void partialMult(double alpha, double[] x, double[] y, int k) {
        double z = x[k];
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double w = this.data[index];
            s += w * x[row];
            int n = row;
            y[n] = y[n] + alpha * w * z;
        }
        int n = k;
        y[n] = y[n] + alpha * s;
    }

    protected void partialSum(double[] y, int k) {
        double s = 0.0;
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            double x = this.data[index];
            s += x;
            int n = row;
            y[n] = y[n] + x;
        }
        int n = k;
        y[n] = y[n] + s;
    }

    public void scale(double alpha) {
        for (int index = 0; index < this.used; ++index) {
            this.data[index] = alpha * this.data[index];
        }
    }

    public void dotDiv(double alpha, double[] x) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            this.data[index] = this.data[index] / (alpha * x[row]);
        }
    }

    public void dotDiv(double[] x) {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            this.data[index] = this.data[index] / x[row];
        }
    }

    public void add(FlexDoubleArray x) throws MatricksException {
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            double x_at_row = x.data[index];
            this.add(row, x_at_row);
        }
    }

    public void addTo(double[] x) throws MatricksException {
        for (int index = 0; index < this.used; ++index) {
            int row = this.indices[index];
            x[row] = x[row] + this.data[index];
        }
    }

    public void add(double alpha, FlexDoubleArray x) throws MatricksException {
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            double x_at_row = x.data[index];
            this.add(row, alpha * x_at_row);
        }
    }

    public void add(int index, double val) throws MatricksException {
        int pos = Utils.myBinarySearch(this.indices, index, 0, this.used);
        if (pos >= 0) {
            this.data[pos] = this.data[pos] + val;
        } else {
            this.insert(-pos - 1, index, val);
        }
    }

    public double elementSum() {
        double sum = 0.0;
        for (int index = 0; index < this.used; ++index) {
            sum += this.data[index];
        }
        return sum;
    }

    public double dot(FlexDoubleArray x) {
        double sum = 0.0;
        for (int index = 0; index < x.used; ++index) {
            int row = x.indices[index];
            double x_at_row = x.data[index];
            int pos = Utils.myBinarySearch(this.indices, row, 0, this.used);
            if (pos < 0) continue;
            sum += this.data[pos] * x_at_row;
        }
        return sum;
    }

    public void compact() {
        if (this.data.length == this.used) {
            return;
        }
        double[] newData = new double[this.used];
        int[] newIndices = new int[this.used];
        System.arraycopy(this.data, 0, newData, 0, this.used);
        System.arraycopy(this.indices, 0, newIndices, 0, this.used);
        this.data = newData;
        this.indices = newIndices;
    }

    private class FlexDoubleArrayCursor
    implements MatrixCursor {
        private int index = -1;

        private FlexDoubleArrayCursor() {
        }

        @Override
        public boolean next() {
            ++this.index;
            return this.index < FlexDoubleArray.this.used;
        }

        @Override
        public int row() {
            return FlexDoubleArray.this.indices[this.index];
        }

        @Override
        public int col() {
            return 0;
        }

        @Override
        public double val() {
            return FlexDoubleArray.this.data[this.index];
        }

        @Override
        public void set(double val) {
            FlexDoubleArray.this.data[this.index] = val;
        }
    }
}

