/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.DenseDoubleVector;

public class DoubleDiagonalMatrix
extends AbstractMatrix {
    int size;
    private Vector data;

    public DoubleDiagonalMatrix(int size) {
        this.size = size;
        this.alloc();
    }

    public DoubleDiagonalMatrix(Vector data) {
        this.size = data.getSize();
        this.data = data;
    }

    private void alloc() {
        this.data = new DenseDoubleVector(this.size);
    }

    @Override
    public int numRows() {
        return this.size;
    }

    @Override
    public int numCols() {
        return this.size;
    }

    @Override
    public double get(int row, int col) {
        if (row == col) {
            return this.data.get(row);
        }
        return 0.0;
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        if (row != col) {
            throw new MatricksException("index error, diagonal matrix row must equal col");
        }
        this.data.set(row, val);
    }

    @Override
    public void scale(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setAll(double a) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementSum() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double elementMultiplySum(Matrix m) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Vector columnSums() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void rowSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void columnSums(double[] result) throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(Vector x, Vector y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void add(int i, int j, double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        this.checkSize(x);
        this.checkSize(y);
        for (int i = 0; i < this.size; ++i) {
            y[i] = x[i] * this.data.get(i);
        }
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        this.checkSize(x);
        this.checkSize(y);
        for (int i = 0; i < this.size; ++i) {
            y[i] = y[i] + x[i] * this.data.get(i);
        }
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void compact() {
        throw new MatricksException("Not implemented");
    }

    private void checkSize(double[] x) {
        if (x.length != this.size) {
            throw new IndexOutOfBoundsException(String.format("invalid size: %d", x.length));
        }
    }
}

