/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.util.Arrays;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.VectorCursor;
import org.genemania.engine.matricks.custom.AbstractVector;
import org.genemania.engine.matricks.custom.DoubleVector;

public class DenseDoubleVector
extends AbstractVector
implements DoubleVector {
    int size;
    double[] data;

    public DenseDoubleVector(int size) {
        this.size = size;
        this.data = new double[size];
    }

    public DenseDoubleVector(double[] data) {
        this.size = data.length;
        this.data = data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public double get(int index) {
        return this.data[index];
    }

    @Override
    public void set(int index, double val) {
        this.data[index] = val;
    }

    @Override
    public void setAll(double a) {
        Arrays.fill(this.data, a);
    }

    @Override
    public void scale(double a) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = this.data[i] * a;
        }
    }

    @Override
    public VectorCursor cursor() {
        return new DenseDoubleVectorCursor();
    }

    @Override
    public void setEqual(Vector b) {
        if (!(b instanceof DenseDoubleVector)) {
            throw new RuntimeException("not implemented for type: " + b.getClass().getName());
        }
        DenseDoubleVector bb = (DenseDoubleVector)b;
        this.setEqual(bb);
    }

    public void setEqual(DenseDoubleVector b) {
        int n = b.getSize();
        if (n != this.data.length) {
            throw new RuntimeException("inconsisten data sizes");
        }
        System.arraycopy(b.data, 0, this.data, 0, n);
    }

    @Override
    public int countMatches(double x) {
        int matches = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != x) continue;
            ++matches;
        }
        return matches;
    }

    @Override
    public void findReplace(double oldValue, double newValue) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != oldValue) continue;
            this.data[i] = newValue;
        }
    }

    @Override
    public double dot(Vector b) throws MatricksException {
        if (b instanceof DenseDoubleVector) {
            DenseDoubleVector bb = (DenseDoubleVector)b;
            return this.dot(bb);
        }
        throw new RuntimeException("unsupported type: " + b.getClass().getName());
    }

    public double dot(DenseDoubleVector b) throws MatricksException {
        if (this.getSize() != b.getSize()) {
            throw new MatricksException("inconsistent size");
        }
        double result = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            result += this.data[i] * b.data[i];
        }
        return result;
    }

    private class DenseDoubleVectorCursor
    implements VectorCursor {
        int index = -1;

        private DenseDoubleVectorCursor() {
        }

        @Override
        public boolean next() {
            ++this.index;
            return this.index != DenseDoubleVector.this.size;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public double val() {
            return DenseDoubleVector.this.data[this.index];
        }

        @Override
        public void set(double val) {
            DenseDoubleVector.this.data[this.index] = val;
        }
    }
}

