/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixAccumulator;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.DenseDoubleVector;
import org.genemania.engine.matricks.custom.SimpleMatrixAccumulator;

public abstract class AbstractMatrix
implements Matrix {
    private static final long serialVersionUID = 3593615653654436162L;
    protected static final String MM_COORDINATE_MATRIX_HEADER = "%%MatrixMarket matrix coordinate real general";

    @Override
    public void scale(double a) throws MatricksException {
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            this.set(cursor.row(), cursor.col(), cursor.val() * a);
        }
    }

    @Override
    public void setAll(double a) throws MatricksException {
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            this.set(cursor.row(), cursor.col(), a);
        }
    }

    @Override
    public void add(Matrix B) throws MatricksException {
        if (B.numRows() != this.numRows() && B.numCols() != this.numCols()) {
            throw new MatricksException("incompatible size for addition");
        }
        MatrixCursor cursor = B.cursor();
        while (cursor.next()) {
            int row = cursor.row();
            int col = cursor.col();
            double v = cursor.val() + this.get(row, col);
            this.set(row, col, v);
        }
    }

    @Override
    public void add(double a, Matrix B) throws MatricksException {
        if (B.numRows() != this.numRows() && B.numCols() != this.numCols()) {
            throw new MatricksException("incompatible size for addition");
        }
        MatrixCursor cursor = B.cursor();
        while (cursor.next()) {
            int row = cursor.row();
            int col = cursor.col();
            double v = a * cursor.val() + this.get(row, col);
            this.set(row, col, v);
        }
    }

    @Override
    public double elementSum() {
        double sum = 0.0;
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            sum += cursor.val();
        }
        return sum;
    }

    @Override
    public double elementMultiplySum(Matrix m) {
        double sum = 0.0;
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            sum += cursor.val() * m.get(cursor.row(), cursor.col());
        }
        return sum;
    }

    @Override
    public void CG(Vector x, Vector y) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void QR(Vector x, Vector y) throws MatricksException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector rowSums() throws MatricksException {
        DenseDoubleVector sums = new DenseDoubleVector(this.numRows());
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            sums.set(cursor.row(), cursor.val() + sums.get(cursor.row()));
        }
        return sums;
    }

    @Override
    public Vector columnSums() throws MatricksException {
        DenseDoubleVector sums = new DenseDoubleVector(this.numCols());
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            sums.set(cursor.col(), cursor.val() + sums.get(cursor.col()));
        }
        return sums;
    }

    @Override
    public void rowSums(double[] result) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void columnSums(double[] result) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setToMaxTranspose() throws MatricksException {
        MatrixCursor cursor = this.cursor();
        while (cursor.next()) {
            double v;
            double u = cursor.val();
            if (u > (v = this.get(cursor.col(), cursor.row()))) {
                this.set(cursor.col(), cursor.row(), u);
                continue;
            }
            if (!(v > u)) continue;
            cursor.set(v);
        }
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void mult(Vector x, Vector y) {
        throw new RuntimeException("not implemented");
    }

    public void dotDivOuterProd(Vector x) {
        MatrixCursor mCursor = this.cursor();
        while (mCursor.next()) {
            mCursor.set(mCursor.val() / (x.get(mCursor.row()) * x.get(mCursor.col())));
        }
    }

    @Override
    public Matrix subMatrix(int[] rows, int[] cols) {
        throw new RuntimeException("not implemented");
    }

    public MatrixCursor columnCursor(int colIndex) {
        throw new RuntimeException("not implemented");
    }

    public MatrixCursor rowCursor(int rowIndex) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void add(int i, int j, double alpha) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void multAdd(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void transMult(double[] x, double[] y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void compact() {
    }

    public static int[] getCommonIndices(int[] indices_a, int len_a, int[] indices_b, int len_b) {
        ArrayList<Integer> common = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < len_a && j < len_b) {
            if (indices_a[i] == indices_b[j]) {
                common.add(indices_a[i]);
                ++i;
                ++j;
                continue;
            }
            if (indices_a[i] < indices_b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        int[] result = new int[common.size()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (Integer)common.get(k);
        }
        return result;
    }

    public static int[] getPositionsOfCommonIndicesOfAInB(int[] indices_a, int len_a, int[] indices_b, int len_b) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < len_a && j < len_b) {
            if (indices_a[i] == indices_b[j]) {
                positions.add(i);
                ++i;
                ++j;
                continue;
            }
            if (indices_a[i] < indices_b[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        int[] result = new int[positions.size()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (Integer)positions.get(k);
        }
        return result;
    }

    @Override
    public MatrixAccumulator accumulator() {
        return new SimpleMatrixAccumulator(this);
    }

    protected int nnz() {
        throw new RuntimeException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mmwrite(String filename) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        try {
            writer.write("%%MatrixMarket matrix coordinate real general\n");
            int nnz = this.nnz();
            writer.write(String.format("%d %d %d\n", this.numRows(), this.numCols(), nnz));
            MatrixCursor cursor = this.cursor();
            int total = 0;
            while (cursor.next()) {
                ++total;
                writer.write(String.format("%d %d %f\n", cursor.row() + 1, cursor.col() + 1, cursor.val()));
            }
            if (total != nnz) {
                throw new MatricksException(String.format("expected %d elements, only found %d", nnz, total));
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public Matrix mmread(String filename) throws IOException {
        throw new RuntimeException("not implemented");
    }
}

