/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.utils;

import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.exception.ApplicationException;

public class ObjectSelector<T> {
    ArrayList<T> elements = new ArrayList();
    ArrayList<Double> scores = new ArrayList();

    public void add(T element, Double score) {
        this.elements.add(element);
        this.scores.add(score);
    }

    public void add(List<T> elements, double[] scores) throws ApplicationException {
        if (elements.size() != scores.length) {
            throw new ApplicationException("inconsistent sizes");
        }
        this.elements.addAll(elements);
        for (double score : scores) {
            this.scores.add(score);
        }
    }

    public void add(FeatureList features, DenseVector scores) throws ApplicationException {
        if (this.elements.size() != scores.size()) {
            throw new ApplicationException("inconsistent sizes");
        }
        this.elements.addAll(this.elements);
        for (int i = 0; i < scores.size(); ++i) {
            this.scores.add(scores.get(i));
        }
    }

    public void add(ObjectSelector<Feature> list) {
        this.elements.addAll(list.getElements());
        this.scores.addAll(list.getScores());
    }

    public int size() {
        return this.elements.size();
    }

    public ObjectSelector<T> selectLevelledSmallestScores(int n, int maxSize) {
        ObjectSelector<T> result = new ObjectSelector<T>();
        if (this.size() == 0 || n == 0) {
            return result;
        }
        DenseVector ranks = this.toDenseVector();
        MatrixUtils.rank((Vector)ranks);
        int[] unrank = new int[this.size()];
        int i = 0;
        while (i < ranks.size()) {
            int ix = (int)Math.round(ranks.get(i)) - 1;
            unrank[ix] = i++;
        }
        ArrayList<Integer> rankStarts = this.getRankStarts(unrank);
        for (int i2 = 0; i2 < rankStarts.size() - 1; ++i2) {
            int rank_start_ix = rankStarts.get(i2);
            int next_rank_start_ix = rankStarts.get(i2 + 1);
            if (result.size() < maxSize) {
                for (int iy = rank_start_ix; iy < next_rank_start_ix; ++iy) {
                    result.add(this.elements.get(unrank[iy]), this.scores.get(unrank[iy]));
                }
            }
            if (result.size() >= n) break;
        }
        return result;
    }

    private ArrayList<Integer> getRankStarts(int[] unrank) {
        ArrayList<Integer> rankStarts = new ArrayList<Integer>();
        if (this.size() == 0) {
            return rankStarts;
        }
        double s = this.scores.get(unrank[0]);
        rankStarts.add(0);
        for (int ix = 1; ix < unrank.length; ++ix) {
            double s2 = this.scores.get(unrank[ix]);
            if (!(s2 > s)) continue;
            s = s2;
            rankStarts.add(ix);
        }
        rankStarts.add(this.size());
        return rankStarts;
    }

    public DenseVector toDenseVector() {
        int n = this.size();
        DenseVector dv = new DenseVector(this.size());
        for (int i = 0; i < n; ++i) {
            dv.set(i, this.scores.get(i).doubleValue());
        }
        return dv;
    }

    public ObjectSelector<T> lt(double v) {
        ObjectSelector<T> result = new ObjectSelector<T>();
        int n = this.scores.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.scores.get(i) < v)) continue;
            result.add(this.elements.get(i), this.scores.get(i));
        }
        return result;
    }

    public ObjectSelector<T> le(double v) {
        ObjectSelector<T> result = new ObjectSelector<T>();
        int n = this.scores.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.scores.get(i) <= v)) continue;
            result.add(this.elements.get(i), this.scores.get(i));
        }
        return result;
    }

    public ObjectSelector<T> gt(double v) {
        ObjectSelector<T> result = new ObjectSelector<T>();
        int n = this.scores.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.scores.get(i) > v)) continue;
            result.add(this.elements.get(i), this.scores.get(i));
        }
        return result;
    }

    public ObjectSelector<T> ge(double v) {
        ObjectSelector<T> result = new ObjectSelector<T>();
        int n = this.scores.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.scores.get(i) >= v)) continue;
            result.add(this.elements.get(i), this.scores.get(i));
        }
        return result;
    }

    public ArrayList<T> getElements() {
        return this.elements;
    }

    public ArrayList<Double> getScores() {
        return this.scores;
    }

    public T getElement(int i) {
        return this.elements.get(i);
    }

    public double getScore(int i) {
        return this.scores.get(i);
    }
}

