/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.gram;

import no.uib.cipr.matrix.DenseMatrix;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.exception.ApplicationException;

public class GramTarget {
    private int size;
    private FeatureList featureList;
    private int biasOffset = 1;
    private DenseMatrix KtK;
    private DenseMatrix KtT;

    public GramTarget(FeatureList featureList, boolean hasBias) {
        this.size = featureList.size();
        this.featureList = featureList;
        this.biasOffset = hasBias ? 1 : 0;
    }

    public void alloc() {
        this.KtK = new DenseMatrix(this.size + this.biasOffset, this.size + this.biasOffset);
        this.KtT = new DenseMatrix(this.size + this.biasOffset, 1);
    }

    public void setGramBias(double bias) throws ApplicationException {
        if (bias == 0.0) {
            throw new ApplicationException("bias value specified but not allowed");
        }
        this.KtK.set(0, 0, bias);
    }

    public void setGramBias(Feature feature, double bias) throws ApplicationException {
        if (bias == 0.0) {
            throw new ApplicationException("bias value specified but not allowed");
        }
    }

    public void setTargetBias(double bias) throws ApplicationException {
        if (bias == 0.0) {
            throw new ApplicationException("bias value specified but not allowed");
        }
        this.KtT.set(0, 0, bias);
    }

    public int getIndex(Feature feature) throws ApplicationException {
        return 0;
    }

    public void setKtT(Feature feature, double val) {
    }

    public void setKtK(Feature feature1, Feature feature2, double val) {
    }

    public void solve() {
    }

    public void getWeights() {
    }

    public DenseMatrix getKtK() {
        return this.KtK;
    }

    public DenseMatrix getKtT() {
        return this.KtT;
    }
}

