/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.gram;

import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;

public class GramEditor {
    public static DenseMatrix RemoveNetworkKtK(DenseMatrix KtK2, List<Integer> sortedIndexOfNetworksToKeep) {
        DenseMatrix temp = new DenseMatrix(sortedIndexOfNetworksToKeep.size(), sortedIndexOfNetworksToKeep.size());
        for (int i = 0; i < sortedIndexOfNetworksToKeep.size(); ++i) {
            for (int j = i; j < sortedIndexOfNetworksToKeep.size(); ++j) {
                temp.set(i, j, KtK2.get(sortedIndexOfNetworksToKeep.get(i).intValue(), sortedIndexOfNetworksToKeep.get(j).intValue()));
                temp.set(j, i, temp.get(i, j));
            }
        }
        return temp;
    }

    public static DenseMatrix RemoveNetworkKtT(DenseMatrix KtT2, List<Integer> sortedIndexOfNetworksToKeep) {
        DenseMatrix temp = new DenseMatrix(sortedIndexOfNetworksToKeep.size(), 1);
        for (int i = 0; i < sortedIndexOfNetworksToKeep.size(); ++i) {
            temp.set(i, 0, KtT2.get(sortedIndexOfNetworksToKeep.get(i).intValue(), 0));
        }
        return temp;
    }

    public static DenseMatrix RemoveNetworkKtK(DenseMatrix ktK, FeatureList gramFeatureList, FeatureList requestedFeatureList) {
        List<Integer> indexOfFeaturesToKeep = GramEditor.getIndexOfFeaturesToKeep(gramFeatureList, requestedFeatureList);
        return GramEditor.RemoveNetworkKtK(ktK, indexOfFeaturesToKeep);
    }

    public static DenseMatrix RemoveNetworkKtT(DenseMatrix ktT, FeatureList gramFeatureList, FeatureList requestedFeatureList) {
        List<Integer> indexOfFeaturesToKeep = GramEditor.getIndexOfFeaturesToKeep(gramFeatureList, requestedFeatureList);
        return GramEditor.RemoveNetworkKtT(ktT, indexOfFeaturesToKeep);
    }

    private static List<Integer> getIndexOfFeaturesToKeep(FeatureList gramFeatureList, FeatureList requestedFeatureList) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Feature feature : requestedFeatureList) {
            int index = gramFeatureList.indexOf(feature);
            if (index < 0) {
                throw new RuntimeException("failed to find index for feature: " + feature);
            }
            indices.add(index);
        }
        return indices;
    }
}

