/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.calculators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import no.uib.cipr.matrix.Vector;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.integration.CombineNetworksOnly;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.attribute.QueryEnrichedAttributeScorer;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class AverageByNetworkCalculator
extends AbstractNetworkWeightCalculator {
    private static int MIN_QUERY_GENES_PER_ATTRIBUTE = 1;
    public static final String PARAM_KEY_FORMAT = "%s-%s";

    public AverageByNetworkCalculator(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, ProgressReporter progress) throws ApplicationException {
        super(namespace, cache, networkIds, attributeGroupIds, organismId, label, attributesLimit, progress);
    }

    @Override
    public void process() throws ApplicationException {
        int i = 0;
        for (Collection group : this.networkIds) {
            Iterator i$ = group.iterator();
            while (i$.hasNext()) {
                long id = (Long)i$.next();
                this.IndexToNetworkIdMap.put(i, id);
                ++i;
            }
        }
        this.progress.setStatus("computing network weights");
        this.progress.setProgress(1);
        QueryEnrichedAttributeScorer attributeScorer = new QueryEnrichedAttributeScorer(this.cache, this.label, MIN_QUERY_GENES_PER_ATTRIBUTE);
        FeatureList featureList = this.buildFeatureList(attributeScorer, true);
        this.weights = AverageByNetworkCalculator.average(featureList);
        this.progress.setStatus("building combined network");
        this.progress.setProgress(2);
        this.combinedMatrix = CombineNetworksOnly.combine(this.weights, this.namespace, this.organismId, this.cache, this.progress);
    }

    protected static FeatureWeightMap average(FeatureList features) {
        FeatureWeightMap weightMap = new FeatureWeightMap();
        int n = features.size();
        if (features.hasBias()) {
            --n;
        }
        double weight = 1.0 / (double)n;
        for (Feature feature : features) {
            if (feature.getType() == Constants.NetworkType.BIAS) continue;
            weightMap.put(feature, weight);
        }
        return weightMap;
    }

    protected static Map<Long, Double> averageNetworksOnly(Map<Integer, Long> IndexToNetworkMap) {
        Double weight = 1.0 / (double)IndexToNetworkMap.size();
        HashMap<Long, Double> matrixToWeightMap = new HashMap<Long, Double>();
        for (Integer i : IndexToNetworkMap.keySet()) {
            matrixToWeightMap.put(IndexToNetworkMap.get(i), weight);
        }
        return matrixToWeightMap;
    }

    @Override
    public String getParameterKey() throws ApplicationException {
        if (this.attributeGroupIds != null && this.attributeGroupIds.size() > 0) {
            throw new ApplicationException("not cacheable");
        }
        String networks = AverageByNetworkCalculator.formattedNetworkList(this.networkIds);
        return String.format(PARAM_KEY_FORMAT, new Object[]{Constants.CombiningMethod.AVERAGE, networks});
    }
}

