/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.QRP;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.utils.Normalization;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.exception.WeightingFailedException;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class Solver {
    private static Logger logger = Logger.getLogger(Solver.class);
    public static double EPSILON = Math.pow(2.0, -52.0);
    public static double DELTA = 1.0E-16;

    public static FeatureWeightMap solve(Matrix KtK2, Vector KtT2, FeatureList featureList, ProgressReporter progress) throws ApplicationException {
        Solver.check(KtK2, KtT2, featureList);
        Vector ss = MatrixUtils.absRowSums(KtK2);
        double maxss = ss.norm(Vector.Norm.Infinity);
        int[] indices = MatrixUtils.findGT(ss, maxss * EPSILON);
        Matrix KtKclean = Matrices.getSubMatrix((Matrix)KtK2, (int[])indices, (int[])indices).copy();
        Vector KtTclean = Matrices.getSubVector((Vector)KtT2, (int[])indices).copy();
        if (Config.instance().isRegularizationEnabled()) {
            double regConst = Config.instance().getRegularizationConstant();
            logger.debug((Object)("applying regularization with constant " + regConst));
            for (int i = 1; i < KtKclean.numRows(); ++i) {
                KtKclean.set(i, i, KtKclean.get(i, i) + regConst);
            }
        }
        boolean done = false;
        int[] posWeights = null;
        DenseVector alpha = null;
        while (!done) {
            if (progress.isCanceled()) {
                throw new CancellationException();
            }
            logger.debug((Object)"solving for weights");
            alpha = new DenseVector(KtTclean.size());
            DenseVector temp = new DenseVector(KtTclean.size());
            DenseVector temp2 = new DenseVector(KtTclean.size());
            try {
                QRP factorization = QRP.factorize((Matrix)KtKclean);
                factorization.getQ().transMult(KtTclean, (Vector)temp);
                factorization.getR().solve((Vector)temp, (Vector)temp2);
                int[] permutation = factorization.getPVector();
                for (int i = 0; i < permutation.length; ++i) {
                    alpha.set(permutation[i], temp2.get(i));
                }
            }
            catch (MatrixSingularException e) {
                throw new WeightingFailedException("Singular Matrix");
            }
            int totalWeights = alpha.size();
            posWeights = MatrixUtils.findGE((Vector)alpha, 0.0 + DELTA);
            if ((posWeights = MatrixUtils.filter(posWeights, 0)).length == 0) {
                throw new WeightingFailedException("All Networks Eliminated");
            }
            if (posWeights.length == totalWeights - 1) break;
            posWeights = MatrixUtils.arrayJoin(new int[]{0}, posWeights);
            KtKclean = Matrices.getSubMatrix((Matrix)KtKclean, (int[])posWeights, (int[])posWeights).copy();
            KtTclean = Matrices.getSubVector((Vector)KtTclean, (int[])posWeights).copy();
            indices = MatrixUtils.subArray(indices, posWeights);
        }
        FeatureWeightMap featureToWeightMap = new FeatureWeightMap();
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == 0) continue;
            double weight = alpha.get(i);
            Feature feature = (Feature)featureList.get(indices[i]);
            if (feature == null) {
                throw new ApplicationException("inconsistent feature indices");
            }
            featureToWeightMap.put(feature, weight);
        }
        if (Config.instance().isNetworkWeightNormalizationEnabled()) {
            logger.debug((Object)"normalizing network weights to add to 1");
            Normalization.normalizeFeatureWeights(featureToWeightMap);
        }
        logger.info((Object)("number of weights : " + featureToWeightMap.size()));
        return featureToWeightMap;
    }

    private static void check(Matrix ktK, Vector ktT, FeatureList featureList) throws ApplicationException {
        int n = ktK.numRows();
        if (ktK.numColumns() != n) {
            throw new ApplicationException("KtK not square");
        }
        if (ktT.size() != n) {
            throw new ApplicationException("KtT size not consistent with KtK");
        }
        if (featureList.size() != n) {
            throw new ApplicationException("feature list size inconsistent with system");
        }
        if (((Feature)featureList.get(0)).getType() != Constants.NetworkType.BIAS) {
            throw new ApplicationException("system must include bias");
        }
    }
}

