/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.genemania.engine.Constants;
import org.genemania.engine.core.integration.Feature;
import org.genemania.exception.ApplicationException;

public class FeatureList
extends ArrayList<Feature> {
    private static final long serialVersionUID = 5333968524718172348L;
    HashMap<String, Integer> reverseMap = null;

    public FeatureList() {
    }

    public FeatureList(int size) {
        super(size);
    }

    public FeatureList(FeatureList featureList, boolean addBias) {
        this.addAll(featureList);
        this.addBias();
    }

    public void validate() throws ApplicationException {
        HashSet<Feature> uniq = new HashSet<Feature>();
        uniq.addAll(this);
        if (uniq.size() != this.size()) {
            throw new ApplicationException("the feature list contains duplicates");
        }
    }

    public Collection<FeatureList> group() {
        HashMap<String, FeatureList> groups = new HashMap<String, FeatureList>();
        for (Feature feature : this) {
            String key = String.format("%s-%d", feature.getType().getCode(), feature.getGroupId());
            FeatureList list = null;
            if (groups.containsKey(key)) {
                list = (FeatureList)groups.get(key);
            } else {
                list = new FeatureList();
                groups.put(key, list);
            }
            list.add(feature);
        }
        return groups.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Feature feature) {
        FeatureList featureList = this;
        synchronized (featureList) {
            if (this.reverseMap == null) {
                this.buildReverseMap();
            }
        }
        String key = this.makeReverseMapKey(feature);
        Integer result = this.reverseMap.get(key);
        if (result == null) {
            return -1;
        }
        return result;
    }

    private String makeReverseMapKey(Feature feature) {
        return feature.key(true);
    }

    void buildReverseMap() {
        this.reverseMap = new HashMap();
        for (int i = 0; i < this.size(); ++i) {
            Feature feature = (Feature)this.get(i);
            String key = this.makeReverseMapKey(feature);
            if (this.reverseMap.containsKey(key)) {
                throw new RuntimeException("consistency error");
            }
            this.reverseMap.put(key, i);
        }
    }

    public void addBias() {
        this.add(0, new Feature(Constants.NetworkType.BIAS, 0L, 0L));
    }

    public void removeBias() {
        if (this.size() > 0 && ((Feature)this.get(0)).getType() == Constants.NetworkType.BIAS) {
            this.remove(0);
        }
    }

    public boolean hasBias() {
        return this.size() > 0 && ((Feature)this.get(0)).getType() == Constants.NetworkType.BIAS;
    }
}

