/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.DenseDoubleVector;
import org.genemania.engine.matricks.custom.MultiOPCSymMatrix;
import org.genemania.engine.matricks.custom.OuterProductComboSymMatrix;
import org.genemania.exception.ApplicationException;

public class CombinedKernelBuilder {
    private DataCache cache;

    public CombinedKernelBuilder(DataCache cache) {
        this.cache = cache;
    }

    public SymMatrix build(long organismId, String namespace, SymMatrix backing, FeatureWeightMap featureWeights) throws ApplicationException {
        Map<Long, Collection<Feature>> groupedAttributes = featureWeights.getGroupedAttributes();
        ArrayList<OuterProductComboSymMatrix> combos = new ArrayList<OuterProductComboSymMatrix>();
        if (groupedAttributes.size() == 0) {
            return backing;
        }
        for (Long attributeGroupId : groupedAttributes.keySet()) {
            Collection<Feature> attributes = groupedAttributes.get(attributeGroupId);
            Vector weights = this.buildWeightsForAttributeGroup(organismId, namespace, attributeGroupId, attributes, featureWeights);
            AttributeData attributeData = this.cache.getAttributeData(namespace, organismId, attributeGroupId);
            OuterProductComboSymMatrix matrix = new OuterProductComboSymMatrix(attributeData.getData(), weights, true);
            combos.add(matrix);
        }
        MultiOPCSymMatrix result = new MultiOPCSymMatrix(backing, combos.toArray(new OuterProductComboSymMatrix[0]));
        return result;
    }

    private Vector buildWeightsForAttributeGroup(long organismId, String namespace, long attributeGroupId, Collection<Feature> attributes, FeatureWeightMap featureWeights) throws ApplicationException {
        AttributeData attributeData = this.cache.getAttributeData(namespace, organismId, attributeGroupId);
        Vector sums = attributeData.getData().columnSums();
        AttributeGroups attributeGroups = this.cache.getAttributeGroups(namespace, organismId);
        ArrayList<Long> allAttributes = attributeGroups.getAttributesForGroup(attributeGroupId);
        DenseDoubleVector weights = new DenseDoubleVector(allAttributes.size());
        for (Feature feature : attributes) {
            int index = attributeGroups.getIndexForAttributeId(attributeGroupId, feature.getId());
            double weight = (Double)featureWeights.get(feature) / (sums.get(index) - 1.0);
            weights.set(index, weight);
        }
        return weights;
    }
}

