/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.MatrixAccumulator;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class CombineNetworksOnly {
    public static Logger logger = Logger.getLogger(CombineNetworksOnly.class);

    public static SymMatrix combine(FeatureWeightMap weightMap, String namespace, long organismId, DataCache cache, ProgressReporter progress) throws ApplicationException {
        return CombineNetworksOnly.combineWithAdder(weightMap, namespace, organismId, cache, progress);
    }

    static SymMatrix basicCombine(FeatureWeightMap weightMap, String namespace, long organismId, DataCache cache, ProgressReporter progress) throws ApplicationException {
        int size = cache.getNodeIds(organismId).getNodeIds().length;
        SymMatrix combined = Config.instance().getMatrixFactory().symSparseMatrix(size);
        for (Feature feature : weightMap.keySet()) {
            if (progress.isCanceled()) {
                throw new CancellationException();
            }
            if (feature.getType() == Constants.NetworkType.SPARSE_MATRIX) {
                double weight = (Double)weightMap.get(feature);
                Network network = cache.getNetwork(namespace, organismId, feature.getId());
                SymMatrix data = network.getData();
                combined.add(weight, data);
                continue;
            }
            if (feature.getType() == Constants.NetworkType.ATTRIBUTE_VECTOR || feature.getType() == Constants.NetworkType.BIAS) continue;
            throw new ApplicationException("unsupported network type");
        }
        logger.info((Object)"Combine Matrix done!");
        return combined;
    }

    static SymMatrix combineWithAdder(FeatureWeightMap weightMap, String namespace, long organismId, DataCache cache, ProgressReporter progress) throws ApplicationException {
        int size = cache.getNodeIds(organismId).getNodeIds().length;
        SymMatrix combined = Config.instance().getMatrixFactory().symSparseMatrix(size);
        MatrixAccumulator adder = combined.accumulator();
        while (adder.nextBlock()) {
            for (Feature feature : weightMap.keySet()) {
                if (progress.isCanceled()) {
                    throw new CancellationException();
                }
                if (feature.getType() == Constants.NetworkType.SPARSE_MATRIX) {
                    double weight = (Double)weightMap.get(feature);
                    Network network = cache.getNetwork(namespace, organismId, feature.getId());
                    SymMatrix data = network.getData();
                    adder.add(weight, data);
                    continue;
                }
                if (feature.getType() == Constants.NetworkType.ATTRIBUTE_VECTOR || feature.getType() == Constants.NetworkType.BIAS) continue;
                throw new ApplicationException("unsupported network type");
            }
        }
        logger.info((Object)"Combine Matrix done!");
        return combined;
    }
}

